/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Complex;
import edu.sc.seis.TauP.VelocityModelException;

public abstract class ReflTrans {
    protected double topVp;
    protected double topVs;
    protected double topDensity;
    protected double botVp;
    protected double botVs;
    protected double botDensity;
    protected double rp;
    protected Complex topVertSlownessP;
    protected Complex topVertSlownessS;
    protected Complex botVertSlownessP;
    protected Complex botVertSlownessS;
    protected double sqBotVs;
    protected double sqTopVs;
    protected double sqBotVp;
    protected double sqTopVp;
    protected double sqRP;
    protected double lastRayParam = -1.0;
    protected boolean lastInIsPWave = true;
    protected static final Complex CX = new Complex();

    public ReflTrans(double topVp, double topVs, double topDensity, double botVp, double botVs, double botDensity) {
        this.topVp = topVp;
        this.topVs = topVs;
        this.topDensity = topDensity;
        this.botVp = botVp;
        this.botVs = botVs;
        this.botDensity = botDensity;
        this.sqBotVs = botVs * botVs;
        this.sqTopVs = topVs * topVs;
        this.sqBotVp = botVp * botVp;
        this.sqTopVp = topVp * topVp;
    }

    public abstract Complex getComplexRpp(double var1) throws VelocityModelException;

    public abstract Complex getComplexRps(double var1) throws VelocityModelException;

    public abstract Complex getComplexTpp(double var1) throws VelocityModelException;

    public abstract Complex getComplexTps(double var1) throws VelocityModelException;

    public abstract Complex getComplexRsp(double var1) throws VelocityModelException;

    public abstract Complex getComplexRss(double var1) throws VelocityModelException;

    public abstract Complex getComplexTsp(double var1) throws VelocityModelException;

    public abstract Complex getComplexTss(double var1) throws VelocityModelException;

    public abstract Complex getComplexRshsh(double var1) throws VelocityModelException;

    public abstract Complex getComplexTshsh(double var1) throws VelocityModelException;

    public abstract ReflTrans flip() throws VelocityModelException;

    public double getRpp(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexRpp(rayParam));
    }

    public double getRps(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexRps(rayParam));
    }

    public double getTpp(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexTpp(rayParam));
    }

    public double getTps(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexTps(rayParam));
    }

    public double getRsp(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexRsp(rayParam));
    }

    public double getRss(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexRss(rayParam));
    }

    public double getTsp(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexTsp(rayParam));
    }

    public double getTss(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexTss(rayParam));
    }

    public double getRshsh(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexRshsh(rayParam));
    }

    public double getTshsh(double rayParam) throws VelocityModelException {
        return ReflTrans.getRealCoefficient(this.getComplexTshsh(rayParam));
    }

    public static double getRealCoefficient(Complex coef) {
        if (Math.abs(coef.im) > 1.0E-6) {
            return Complex.abs(coef);
        }
        return coef.re;
    }

    public Complex calcInVerticalSlownessP(double flatRP) {
        return Complex.sqrt(new Complex(1.0 / this.sqTopVp - flatRP * flatRP));
    }

    public Complex calcInVerticalSlownessS(double flatRP) {
        return Complex.sqrt(new Complex(1.0 / this.sqTopVs - flatRP * flatRP));
    }

    public Complex calcTransVerticalSlownessP(double flatRP) {
        return Complex.sqrt(new Complex(1.0 / this.sqBotVp - flatRP * flatRP));
    }

    public Complex calcTransVerticalSlownessS(double flatRP) {
        return Complex.sqrt(new Complex(1.0 / this.sqBotVs - flatRP * flatRP));
    }

    public double[] calcCriticalRayParams() {
        return new double[]{1.0 / this.topVp, 1.0 / this.botVp, 1.0 / this.topVs, 1.0 / this.botVs};
    }

    public double getAngleR_p(double flatRP) {
        double cosTopVp = Math.sqrt(1.0 - flatRP * flatRP * this.topVp * this.topVp);
        return Math.acos(cosTopVp) * 57.29577951308232;
    }

    public double getAngleR_s(double flatRP) {
        double cosTopVs = Math.sqrt(1.0 - flatRP * flatRP * this.topVs * this.topVs);
        return Math.acos(cosTopVs) * 57.29577951308232;
    }

    public double getAngleT_p(double flatRP) {
        double cosBotVp = Math.sqrt(1.0 - flatRP * flatRP * this.botVp * this.botVp);
        return Math.acos(cosBotVp) * 57.29577951308232;
    }

    public double getAngleT_s(double flatRP) {
        double cosBotVs = Math.sqrt(1.0 - flatRP * flatRP * this.botVs * this.botVs);
        return Math.acos(cosBotVs) * 57.29577951308232;
    }

    public double inboundEnergyP(double flatRP) {
        this.calcTempVars(flatRP, true);
        if (this.topVertSlownessP.isInfinite()) {
            return 0.0;
        }
        double cos_j1 = Complex.abs(this.topVertSlownessP) * this.topVp;
        return this.topDensity * this.topVp * cos_j1;
    }

    public double inboundEnergyS(double flatRP) {
        this.calcTempVars(flatRP, false);
        if (this.topVertSlownessP.isInfinite()) {
            return 0.0;
        }
        double cos_j1 = Complex.abs(this.topVertSlownessS) * this.topVs;
        return this.topDensity * this.topVs * cos_j1;
    }

    public double getEnergyFluxRpp(double flatRP) throws VelocityModelException {
        double eff = this.getEnergyFluxFactorRpp(flatRP);
        return eff * eff;
    }

    public double getEnergyFluxFactorRpp(double flatRP) throws VelocityModelException {
        if (1.0 / flatRP == this.topVp) {
            return 1.0;
        }
        double cosArg = 1.0 - flatRP * flatRP * this.topVp * this.topVp;
        if (cosArg < 0.0) {
            return 0.0;
        }
        double inboundEnergy = this.inboundEnergyP(flatRP);
        if (inboundEnergy == 0.0) {
            return 0.0;
        }
        double Rpp_calc = this.getRpp(flatRP);
        return Rpp_calc * Math.sqrt(this.topDensity * this.topVp * Math.sqrt(cosArg) / inboundEnergy);
    }

    public double getEnergyFluxTpp(double flatRP) throws VelocityModelException {
        double eff = this.getEnergyFluxFactorTpp(flatRP);
        return eff * eff;
    }

    public double getEnergyFluxFactorTpp(double flatRP) throws VelocityModelException {
        double cosArg = 1.0 - flatRP * flatRP * this.botVp * this.botVp;
        if (cosArg < 0.0) {
            return 0.0;
        }
        double inboundEnergy = this.inboundEnergyP(flatRP);
        if (inboundEnergy == 0.0) {
            return 0.0;
        }
        double Tpp_calc = this.getTpp(flatRP);
        return Tpp_calc * Math.sqrt(this.botDensity * this.botVp * Math.sqrt(cosArg) / inboundEnergy);
    }

    public double getEnergyFluxRps(double flatRP) throws VelocityModelException {
        double eff = this.getEnergyFluxFactorRps(flatRP);
        return eff * eff;
    }

    public double getEnergyFluxFactorRps(double flatRP) throws VelocityModelException {
        if (this.topVs == 0.0) {
            return 0.0;
        }
        double cosArg = 1.0 - flatRP * flatRP * this.topVs * this.topVs;
        if (cosArg < 0.0) {
            return 0.0;
        }
        double inboundEnergy = this.inboundEnergyP(flatRP);
        if (inboundEnergy == 0.0) {
            return 0.0;
        }
        double Rps_calc = this.getRps(flatRP);
        return Rps_calc * Math.sqrt(this.topDensity * this.topVs * Math.sqrt(cosArg) / inboundEnergy);
    }

    public double getEnergyFluxTps(double flatRP) throws VelocityModelException {
        double eff = this.getEnergyFluxFactorTps(flatRP);
        return eff * eff;
    }

    public double getEnergyFluxFactorTps(double flatRP) throws VelocityModelException {
        if (this.botVs == 0.0) {
            return 0.0;
        }
        double cosArg = 1.0 - flatRP * flatRP * this.botVs * this.botVs;
        if (cosArg < 0.0) {
            return 0.0;
        }
        double inboundEnergy = this.inboundEnergyP(flatRP);
        if (inboundEnergy == 0.0) {
            return 0.0;
        }
        double Tps_calc = this.getTps(flatRP);
        return Tps_calc * Math.sqrt(this.botDensity * this.botVs * Math.sqrt(cosArg) / inboundEnergy);
    }

    public double getEnergyFluxRsp(double flatRP) throws VelocityModelException {
        double eff = this.getEnergyFluxFactorRsp(flatRP);
        return eff * eff;
    }

    public double getEnergyFluxFactorRsp(double flatRP) throws VelocityModelException {
        if (this.topVs == 0.0) {
            return 0.0;
        }
        double cosArg = 1.0 - flatRP * flatRP * this.topVp * this.topVp;
        if (cosArg < 0.0) {
            return 0.0;
        }
        double inboundEnergy = this.inboundEnergyS(flatRP);
        if (inboundEnergy == 0.0) {
            return 0.0;
        }
        double Rsp_calc = this.getRsp(flatRP);
        return Rsp_calc * Math.sqrt(this.topDensity * this.topVp * Math.sqrt(cosArg) / inboundEnergy);
    }

    public double getEnergyFluxTsp(double flatRP) throws VelocityModelException {
        double eff = this.getEnergyFluxFactorTsp(flatRP);
        return eff * eff;
    }

    public double getEnergyFluxFactorTsp(double flatRP) throws VelocityModelException {
        if (this.topVs == 0.0) {
            return 0.0;
        }
        double cosArg = 1.0 - flatRP * flatRP * this.botVp * this.botVp;
        if (cosArg < 0.0) {
            return 0.0;
        }
        double inboundEnergy = this.inboundEnergyS(flatRP);
        if (inboundEnergy == 0.0) {
            return 0.0;
        }
        double Tsp_calc = this.getTsp(flatRP);
        return Tsp_calc * Math.sqrt(this.botDensity * this.botVp * Math.sqrt(cosArg) / inboundEnergy);
    }

    public double getEnergyFluxRss(double flatRP) throws VelocityModelException {
        double eff = this.getEnergyFluxFactorRss(flatRP);
        return eff * eff;
    }

    public double getEnergyFluxFactorRss(double flatRP) throws VelocityModelException {
        if (this.topVs == 0.0) {
            return 0.0;
        }
        if (1.0 / flatRP == this.topVs) {
            return 1.0;
        }
        double cosArg = 1.0 - flatRP * flatRP * this.topVs * this.topVs;
        if (cosArg < 0.0) {
            return 1.0;
        }
        double inboundEnergy = this.inboundEnergyS(flatRP);
        if (inboundEnergy == 0.0) {
            return 1.0;
        }
        double Rss_calc = this.getRss(flatRP);
        return Rss_calc * Math.sqrt(this.topDensity * this.topVs * Math.sqrt(cosArg) / inboundEnergy);
    }

    public double getEnergyFluxTss(double flatRP) throws VelocityModelException {
        double eff = this.getEnergyFluxFactorTss(flatRP);
        return eff * eff;
    }

    public double getEnergyFluxFactorTss(double flatRP) throws VelocityModelException {
        double cosArg = 1.0 - flatRP * flatRP * this.botVs * this.botVs;
        if (cosArg < 0.0) {
            return 0.0;
        }
        double inboundEnergy = this.inboundEnergyS(flatRP);
        if (inboundEnergy == 0.0) {
            return 0.0;
        }
        if (this.topVs == 0.0 || this.botVs == 0.0) {
            return 0.0;
        }
        double Tss_calc = this.getTss(flatRP);
        return Tss_calc * Math.sqrt(this.botDensity * this.botVs * Math.sqrt(cosArg) / inboundEnergy);
    }

    public double getEnergyFluxRshsh(double flatRP) throws VelocityModelException {
        double eff = this.getEnergyFluxFactorRshsh(flatRP);
        return eff * eff;
    }

    public double getEnergyFluxFactorRshsh(double flatRP) throws VelocityModelException {
        if (this.topVs == 0.0) {
            return 0.0;
        }
        if (1.0 / flatRP == this.topVs) {
            return 1.0;
        }
        double cosArg = 1.0 - flatRP * flatRP * this.topVs * this.topVs;
        if (cosArg < 0.0) {
            return 0.0;
        }
        double inboundEnergy = this.inboundEnergyS(flatRP);
        if (inboundEnergy == 0.0) {
            return 0.0;
        }
        double Rshsh_calc = this.getRshsh(flatRP);
        return Rshsh_calc * Math.sqrt(this.topDensity * this.topVs * Math.sqrt(cosArg) / inboundEnergy);
    }

    public double getEnergyFluxTshsh(double flatRP) throws VelocityModelException {
        double eff = this.getEnergyFluxFactorTshsh(flatRP);
        return eff * eff;
    }

    public double getEnergyFluxFactorTshsh(double flatRP) throws VelocityModelException {
        if (this.topVs == 0.0 || this.botVs == 0.0) {
            return 0.0;
        }
        double cosArg = 1.0 - flatRP * flatRP * this.botVs * this.botVs;
        if (cosArg < 0.0) {
            return 0.0;
        }
        double inboundEnergy = this.inboundEnergyS(flatRP);
        if (inboundEnergy == 0.0) {
            return 0.0;
        }
        double Tshsh_calc = this.getTshsh(flatRP);
        return Tshsh_calc * Math.sqrt(this.botDensity * this.botVs * Math.sqrt(cosArg) / inboundEnergy);
    }

    public double getTopVp() {
        return this.topVp;
    }

    public double getTopVs() {
        return this.topVs;
    }

    public double getTopDensity() {
        return this.topDensity;
    }

    public double getBotVp() {
        return this.botVp;
    }

    public double getBotVs() {
        return this.botVs;
    }

    public double getBotDensity() {
        return this.botDensity;
    }

    protected abstract void calcTempVars(double var1, boolean var3);
}

