/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.StdModelGenerator;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import edu.sc.seis.TauP.cmdline.args.VelocityModelArgs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

public class VelocityModelListArgs {
    List<VelocityModelArgs> velocityModelArgsList = new ArrayList<VelocityModelArgs>();
    List<VelocityModel> vModList = null;

    @CommandLine.Option(names={"--mod", "--model"}, description={"use velocity model \"modelname\" for calculations, format is guessed."}, paramLabel="model", completionCandidates=StdModelGenerator.StdModelCandidates.class)
    public void setModelName(List<String> modelFilenames) {
        for (String modname : modelFilenames) {
            VelocityModelArgs vmodArg = new VelocityModelArgs();
            vmodArg.setVelFileType(null);
            vmodArg.setModelFilename(modname);
            this.addIfNotAlready(vmodArg);
        }
    }

    @CommandLine.Option(names={"--nd"}, paramLabel="model", description={"\"named discontinuities\" velocity file"})
    public void setNDModelFilename(List<String> modelFilenames) {
        for (String modname : modelFilenames) {
            VelocityModelArgs vmodArg = new VelocityModelArgs();
            vmodArg.setVelFileType("nd");
            vmodArg.setModelFilename(modname);
            this.addIfNotAlready(vmodArg);
        }
    }

    @CommandLine.Option(names={"--tvel"}, paramLabel="model", description={"\".tvel\" velocity file, ala ttimes"})
    public void setTvelModelFilename(List<String> modelFilenames) {
        for (String modname : modelFilenames) {
            VelocityModelArgs vmodArg = new VelocityModelArgs();
            vmodArg.setVelFileType("tvel");
            vmodArg.setModelFilename(modname);
            this.addIfNotAlready(vmodArg);
        }
    }

    public void addIfNotAlready(VelocityModelArgs vmodArg) {
        for (VelocityModelArgs existingVMod : this.velocityModelArgsList) {
            if (!existingVMod.modelFilename.equals(vmodArg.getModelFilename())) continue;
            return;
        }
        this.velocityModelArgsList.add(vmodArg);
    }

    public List<VelocityModel> getVelocityModels() throws VelocityModelException, IOException {
        if (this.vModList == null) {
            this.vModList = new ArrayList<VelocityModel>();
            for (VelocityModelArgs vmodArg : this.getVelocityModelArgsList()) {
                VelocityModel vMod = TauModelLoader.loadVelocityModel(vmodArg.getModelFilename(), vmodArg.getVelFileType());
                if (vMod == null) {
                    throw new VelocityModelException("Velocity model file not found: " + vmodArg.getModelFilename() + ", tried internally and from file");
                }
                this.vModList.add(vMod);
            }
        }
        return this.vModList;
    }

    public void clear() {
        this.vModList.clear();
        this.velocityModelArgsList.clear();
    }

    public int size() {
        return this.velocityModelArgsList.size();
    }

    public List<VelocityModelArgs> getVelocityModelArgsList() {
        return this.velocityModelArgsList;
    }
}

