/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.ModelDiscontinuites;
import edu.sc.seis.TauP.NamedVelocityDiscon;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.args.TextOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.VelocityModelListArgs;
import edu.sc.seis.TauP.gson.GsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="discon", description={"List velocity discontinuities for a model."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_VelocityDison
extends TauP_Tool {
    @CommandLine.ArgGroup(heading="Velocity Model %n")
    VelocityModelListArgs velModelArgs = new VelocityModelListArgs();
    @CommandLine.Mixin
    TextOutputTypeArgs outputTypeArgs = (TextOutputTypeArgs)this.abstractOutputTypeArgs;

    public TauP_VelocityDison() {
        super(new TextOutputTypeArgs("text", "-"));
    }

    public TextOutputTypeArgs getOutputTypeArgs() {
        return this.outputTypeArgs;
    }

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void start() throws IOException, TauPException {
        List<VelocityModel> vModList = this.getVelModelArgs().getVelocityModels();
        if (this.outputTypeArgs.isJSON()) {
            ArrayList<ModelDiscontinuites> outList = new ArrayList<ModelDiscontinuites>();
            for (VelocityModel vMod : vModList) {
                outList.add(new ModelDiscontinuites(vMod));
            }
            PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
            Gson gson = GsonUtil.createGsonBuilder().create();
            JsonObject out = new JsonObject();
            out.add("models", gson.toJsonTree(outList));
            writer.println(gson.toJson((JsonElement)out));
            writer.close();
        } else if (this.outputTypeArgs.isHTML()) {
            PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
            List<String> headers = List.of("Depth", "Radius", "Name", "Vp", "Vs", "Density");
            HTMLUtil.createHtmlStart(writer, "TauP Discon", HTMLUtil.createBaseTableCSS() + "\n" + HTMLUtil.createThridRowCSS(), false);
            for (VelocityModel vMod : vModList) {
                ArrayList<List<String>> values = new ArrayList<List<String>>();
                for (double d : vMod.getDisconDepths()) {
                    NamedVelocityDiscon discon = vMod.getNamedDisconForDepth(d);
                    String disconName = discon == null ? "" : "  " + discon.getPreferredName();
                    VelocityLayer above = vMod.getVelocityLayer(vMod.layerNumberAbove(d));
                    VelocityLayer below = vMod.getVelocityLayer(vMod.layerNumberBelow(d));
                    if (d != 0.0) {
                        values.add(List.of("", "", "", "" + above.getBotPVelocity(), "" + above.getBotSVelocity(), "" + above.getBotDensity()));
                    }
                    values.add(List.of(Outputs.formatDepth(d), Outputs.formatDepth(vMod.getRadiusOfEarth() - d), disconName, "", "", ""));
                    if (d == vMod.getRadiusOfEarth()) continue;
                    values.add(List.of("", "", "", "" + below.getBotPVelocity(), "" + below.getBotSVelocity(), "" + below.getBotDensity()));
                }
                writer.println("<details open=\"true\">");
                writer.println("  <summary>" + vMod.getModelName() + "</summary>");
                writer.println(HTMLUtil.createBasicTable(headers, values));
                writer.println("</details>");
            }
            writer.println(HTMLUtil.createHtmlEnding());
            writer.close();
        } else {
            this.outputTypeArgs.setOutputFormat("text");
            PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
            for (VelocityModel vMod : vModList) {
                writer.println("# " + vMod.getModelName());
                writer.println("#        Depth    (Radius)");
                writer.println("#        Vp      Vs      Density");
                for (double d : vMod.getDisconDepths()) {
                    NamedVelocityDiscon discon = vMod.getNamedDisconForDepth(d);
                    String disconName = discon == null ? "" : "  " + discon.getPreferredName();
                    VelocityLayer above = vMod.getVelocityLayer(vMod.layerNumberAbove(d));
                    VelocityLayer below = vMod.getVelocityLayer(vMod.layerNumberBelow(d));
                    if (d != 0.0) {
                        writer.println("      " + Outputs.formatRayParam(above.getBotPVelocity()) + " " + Outputs.formatRayParam(above.getBotSVelocity()) + " " + Outputs.formatRayParam(above.getBotDensity()));
                    }
                    writer.println("---" + Outputs.formatDepth(d) + " " + Outputs.formatDepth(vMod.getRadiusOfEarth() - d) + " " + disconName);
                    if (d != vMod.getRadiusOfEarth()) {
                        writer.println("      " + Outputs.formatRayParam(below.getTopPVelocity()) + " " + Outputs.formatRayParam(below.getTopSVelocity()) + " " + Outputs.formatRayParam(below.getTopDensity()));
                    }
                    writer.println();
                }
            }
            writer.close();
        }
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        if (this.velModelArgs.size() == 0) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "must give at least one model");
        }
    }

    public VelocityModelListArgs getVelModelArgs() {
        return this.velModelArgs;
    }
}

