/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.GsonBuilder;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.HTMLUtil;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.ScatteredArrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SvgEarth;
import edu.sc.seis.TauP.SvgEarthScaling;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.TimeResult;
import edu.sc.seis.TauP.cmdline.TauP_AbstractRayTool;
import edu.sc.seis.TauP.cmdline.TauP_Time;
import edu.sc.seis.TauP.cmdline.args.ColorType;
import edu.sc.seis.TauP.cmdline.args.ColoringArgs;
import edu.sc.seis.TauP.cmdline.args.DistDepthRange;
import edu.sc.seis.TauP.cmdline.args.GraphicOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.ModelArgs;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import edu.sc.seis.TauP.gson.ArrivalSerializer;
import edu.sc.seis.TauP.gson.GsonUtil;
import edu.sc.seis.TauP.gson.ScatteredArrivalSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="path", description={"Plot ray paths, distance vs. depth, through the earth."}, optionListHeading="%nOptions:%n%n", abbreviateSynopsis=false, usageHelpAutoWidth=true)
public class TauP_Path
extends TauP_AbstractRayTool {
    protected boolean withTime = false;
    protected float maxPathTime = Float.MAX_VALUE;
    protected static double maxPathInc = 1.0;
    @CommandLine.Mixin
    ColoringArgs coloring = new ColoringArgs();
    @CommandLine.Option(names={"--legend"}, description={"create a legend"})
    boolean isLegend = false;
    @CommandLine.Option(names={"--label"}, description={"label with phase name"})
    boolean isLabel = false;
    @CommandLine.Mixin
    DistDepthRange distDepthRange = new DistDepthRange();
    @CommandLine.Option(names={"--onlynameddiscon"}, description={"only draw circles on the plot for named discontinuities like moho, cmb, iocb"})
    boolean onlyNamedDiscon = false;
    @CommandLine.Mixin
    GraphicOutputTypeArgs outputTypeArgs = (GraphicOutputTypeArgs)this.abstractOutputTypeArgs;

    public TauP_Path() {
        super(new GraphicOutputTypeArgs("text", "taup_path"));
    }

    public TauP_Path(String modelName) {
        this();
        this.modelArgs.setModelName(modelName);
    }

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    public void setMapWidth(float mapWidth) {
        this.getGraphicOutputTypeArgs().mapwidth = Float.valueOf(mapWidth);
    }

    public float getMapWidth() {
        return this.getGraphicOutputTypeArgs().mapwidth.floatValue();
    }

    public String getMapWidthUnit() {
        return this.getGraphicOutputTypeArgs().mapWidthUnit;
    }

    public void setMapWidthUnit(String mapWidthUnit) {
        this.getGraphicOutputTypeArgs().mapWidthUnit = mapWidthUnit;
    }

    public float getMaxPathTime() {
        return this.maxPathTime;
    }

    public void setMaxPathTime(float maxPathTime) {
        this.maxPathTime = maxPathTime;
    }

    public boolean isWithTime() {
        return this.withTime;
    }

    @CommandLine.Option(names={"--withtime"}, description={"include time for each path point, no effect for SVG."})
    public void setWithTime(boolean withTime) {
        this.withTime = withTime;
    }

    public double[] getDepthAxisMinMax() {
        return this.distDepthRange.getDepthAxisMinMax();
    }

    public static double getMaxPathInc() {
        return maxPathInc;
    }

    @CommandLine.Option(names={"--maxpathinc"}, defaultValue="1.0", description={"Maximum distance increment in degrees between path points, avoid visible segmentation in plots"})
    public static void setMaxPathInc(double max) {
        maxPathInc = max;
    }

    public GraphicOutputTypeArgs getGraphicOutputTypeArgs() {
        return this.outputTypeArgs;
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public List<Arrival> calcAll(List<SeismicPhase> phaseList, List<RayCalculateable> shootables) throws TauPException {
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (SeismicPhase phase : phaseList) {
            for (RayCalculateable shoot : shootables) {
                if (!TauP_Time.isRayOkForPhase(shoot, phase)) continue;
                arrivals.addAll(shoot.calculate(phase));
            }
        }
        for (Arrival arrival : arrivals) {
            arrival.getPath();
        }
        Arrival.sortArrivals(arrivals);
        return arrivals;
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void printResult(PrintWriter out, List<Arrival> arrivalList) throws IOException, TauPException {
        boolean withPierce = false;
        boolean withPath = true;
        boolean withAmp = false;
        SeismicSourceArgs sourceArgs = null;
        if (this.getOutputFormat().equals("json")) {
            TimeResult result = this.createTimeResult(withAmp, sourceArgs, arrivalList);
            GsonBuilder gsonBuilder = GsonUtil.createGsonBuilder();
            gsonBuilder.registerTypeAdapter(Arrival.class, (Object)new ArrivalSerializer(withPierce, withPath, withAmp));
            gsonBuilder.registerTypeAdapter(ScatteredArrival.class, (Object)new ScatteredArrivalSerializer(withPierce, withPath, withAmp));
            out.println(gsonBuilder.create().toJson((Object)result));
        } else if (this.getOutputFormat().equals("svg")) {
            this.printResultSVG(out, arrivalList);
        } else if (this.getOutputFormat().equals("html")) {
            this.printResultHtml(out, arrivalList);
        } else {
            if (this.getGraphicOutputTypeArgs().isGMT()) {
                SvgEarth.printGmtScriptBeginning(out, this.outputTypeArgs.getGmtOutFileBase("taup_path"), this.modelArgs.getTauModel(), this.outputTypeArgs.mapwidth.floatValue(), this.outputTypeArgs.mapWidthUnit, this.onlyNamedDiscon, TauP_Path.toolNameFromClass(this.getClass()), this.getCmdLineArgs());
                if (this.coloring.getColoring() != ColorType.wavetype) {
                    out.write("gmt plot -A <<END\n");
                }
            }
            for (Arrival arrival : arrivalList) {
                for (ArrivalPathSegment seg : arrival.getPathSegments()) {
                    ArrivalPathSegment interpSeg = ArrivalPathSegment.linearInterpPath(seg, maxPathInc, this.maxPathTime);
                    if (this.getGraphicOutputTypeArgs().isGMT() && this.coloring.getColoring() == ColorType.wavetype) {
                        String colorArg = "-W" + (interpSeg.isPWave() ? "blue" : "red") + " ";
                        out.write("gmt plot " + colorArg + " -A  <<END\n");
                    }
                    interpSeg.writeGMTText(out, this.distDepthRange, Outputs.distanceFormat, Outputs.depthFormat, this.withTime);
                    if (!this.getGraphicOutputTypeArgs().isGMT() || this.coloring.getColoring() != ColorType.wavetype) continue;
                    out.println("END");
                }
            }
            if (this.getGraphicOutputTypeArgs().isGMT()) {
                if (this.coloring.getColoring() != ColorType.wavetype) {
                    out.write("END\n");
                }
                this.printLabelsGMT(out, arrivalList);
                out.println("# end postscript");
                out.println("gmt end ");
            }
        }
        out.flush();
    }

    public void printResultHtml(PrintWriter writer, List<Arrival> arrivalList) throws TauPException {
        HTMLUtil.createHtmlStart(writer, "TauP Path", "", false);
        String modelLine = String.join((CharSequence)"", TauP_Time.createModelHeaderLine(this.getTauModelName(), this.getScatterer()));
        writer.println("<h5>" + modelLine + "</h5>");
        this.printResultSVG(writer, arrivalList);
        writer.println(HTMLUtil.createHtmlEnding());
    }

    public void printResultSVG(PrintWriter out, List<Arrival> arrivalList) throws TauPException {
        float pixelWidth = this.outputTypeArgs.getPixelWidth();
        this.printScriptBeginningSVG(out, arrivalList, pixelWidth, this.distDepthRange, this.modelArgs, this.getCmdLineArgs());
        if (this.coloring.getColoring() == ColorType.auto) {
            SvgUtil.startAutocolorG(out);
        }
        for (Arrival arrival : arrivalList) {
            out.println("<g>");
            out.println("    <desc>" + arrival.toString() + "</desc>");
            for (ArrivalPathSegment seg : arrival.getPathSegments()) {
                ArrivalPathSegment interpSeg = ArrivalPathSegment.linearInterpPath(seg, maxPathInc, this.maxPathTime);
                if (this.distDepthRange.distAxisType == null && this.distDepthRange.depthAxisType == null) {
                    interpSeg.writeSVGCartesian(out);
                    continue;
                }
                throw new CommandLine.ParameterException(this.spec.commandLine(), "other dist, depth axis types not impl for --svg output");
            }
            out.println("</g>");
        }
        if (this.coloring.getColoring() == ColorType.auto) {
            SvgUtil.endAutocolorG(out);
        }
        if (this.isLabel) {
            this.labelPathsSVG(out, arrivalList);
        }
        SvgEarth.printSvgEndZoom(out);
        if (this.isLegend) {
            float xtrans = (int)((double)pixelWidth * 0.01);
            float ytrans = (int)((double)pixelWidth * 0.05);
            switch (this.coloring.getColoring()) {
                case auto: 
                case phase: {
                    SvgUtil.createPhaseLegend(out, this.getSeismicPhases(), "", xtrans, ytrans);
                    break;
                }
                case wavetype: {
                    SvgUtil.createWavetypeLegend(out, false, xtrans, ytrans);
                    break;
                }
            }
        }
        SvgEarth.printSvgEnd(out);
    }

    public void printLabelsGMT(PrintWriter out, List<Arrival> arrivalList) {
        if (this.getGraphicOutputTypeArgs().isGMT()) {
            out.write("gmt text -F+f+a+j <<ENDLABELS\n");
        }
        if (this.getGraphicOutputTypeArgs().isGMT()) {
            for (Arrival currArrival : arrivalList) {
                double radiusOfEarth = currArrival.getTauModel().getRadiusOfEarth();
                TimeDist[] path = currArrival.getPath();
                int midSample = path.length / 2;
                double calcDepth = path[midSample].getDepth();
                double calcDist = path[midSample].getDistDeg();
                double radius = radiusOfEarth - calcDepth;
                if (!this.getGraphicOutputTypeArgs().isGMT()) continue;
                out.write(SvgEarth.formatDistRadius(calcDist, radius) + " 10 0 MR " + currArrival.getName() + "\n");
            }
        }
        if (this.getGraphicOutputTypeArgs().isGMT()) {
            out.write("ENDLABELS\n");
        }
    }

    public void labelPathsSVG(PrintWriter out, List<Arrival> arrivalList) {
        out.println("    <g class=\"label phasename\">");
        for (Arrival currArrival : arrivalList) {
            double radiusOfEarth = currArrival.getTauModel().getRadiusOfEarth();
            double distFactor = 1.0;
            if (currArrival.isLongWayAround()) {
                distFactor = -1.0;
            }
            TimeDist[] path = currArrival.getPath();
            int midSample = path.length / 2;
            double calcDepth = path[midSample].getDepth();
            double calcDist = distFactor * path[midSample].getDistDeg();
            double radius = radiusOfEarth - calcDepth;
            double radian = (calcDist - 90.0) * Math.PI / 180.0;
            double x = radius * Math.cos(radian);
            double y = radius * Math.sin(radian);
            out.println("      <text class=\"" + SvgUtil.classForPhase(currArrival.getName()) + "\" x=\"" + Outputs.formatDistance(x) + "\" y=\"" + Outputs.formatDistance(y) + "\">" + currArrival.getName() + "</text>");
        }
        out.println("    </g> <!-- end labels -->");
    }

    public void printScriptBeginningSVG(PrintWriter out, List<Arrival> arrivalList, float pixelWidth, DistDepthRange distDepthRange, ModelArgs modelArgs, List<String> cmdLineArgs) throws TauPException {
        TauModel tMod = modelArgs.getTauModel();
        SvgEarthScaling scaleTrans = SvgEarth.calcEarthScaleTrans(arrivalList, distDepthRange);
        Object extraCSS = "";
        List<PhaseName> phaseNameList = this.parsePhaseNameList();
        extraCSS = (String)extraCSS + String.valueOf(SvgUtil.createSurfaceWaveCSS(phaseNameList)) + "\n";
        switch (this.coloring.getColoring()) {
            case auto: 
            case phase: {
                extraCSS = (String)extraCSS + String.valueOf(SvgUtil.createPhaseColorCSS(phaseNameList, this.coloring));
                break;
            }
            case wavetype: {
                extraCSS = (String)extraCSS + String.valueOf(SvgUtil.createWaveTypeColorCSS(this.coloring));
                break;
            }
            default: {
                extraCSS = (String)extraCSS + String.valueOf(SvgUtil.createNoneColorCSS(this.coloring));
            }
        }
        SvgEarth.printScriptBeginningSvg(out, tMod, pixelWidth, scaleTrans, TauP_Path.toolNameFromClass(this.getClass()), cmdLineArgs, this.coloring.getColorList(), (String)extraCSS);
        SvgEarth.printModelAsSVG(out, tMod, pixelWidth, scaleTrans, this.onlyNamedDiscon);
    }

    @Override
    public void init() throws TauPException {
        super.init();
    }

    @Override
    public void start() throws IOException, TauPException {
        List<RayCalculateable> distanceValues = this.getDistanceArgs().getRayCalculatables();
        List<Arrival> arrivalList = this.calcAll(this.getSeismicPhases(), distanceValues);
        PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        this.printResult(writer, arrivalList);
        writer.close();
    }

    @Override
    public void validateArguments() throws TauPException {
        super.validateArguments();
        if ((this.getGraphicOutputTypeArgs().isSVG() || this.getGraphicOutputTypeArgs().isGMT()) && (this.distDepthRange.distAxisType != null || this.distDepthRange.depthAxisType != null)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "--xaxis and --yaxis not compatible with --svg or --gmt");
        }
    }
}

