/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

public class SvgEarthScaling {
    double[] boundingBox;
    double R;
    float zoomScale;
    float zoomTranslateX;
    float zoomTranslateY;
    double minDataDist;
    double maxDataDist;
    float minLabelDist = -180.0f;
    float maxLabelDist = 180.0f;

    public SvgEarthScaling(double R) {
        this(new double[]{-R, R, -R, R}, R);
    }

    public SvgEarthScaling(double[] boundingBox, double R) {
        this.R = R;
        this.boundingBox = boundingBox;
        float[] scaleTrans = SvgEarthScaling.calcZoomScaleTranslate((float)boundingBox[0], (float)boundingBox[1], (float)boundingBox[2], (float)boundingBox[3], (float)R, 0.0f, 0.0f);
        this.zoomScale = scaleTrans[0];
        this.zoomTranslateX = scaleTrans[1];
        this.zoomTranslateY = scaleTrans[2];
        this.minDataDist = scaleTrans[3];
        this.maxDataDist = scaleTrans[4];
    }

    public float getZoomScale() {
        return this.zoomScale;
    }

    public float getZoomTranslateX() {
        return this.zoomTranslateX;
    }

    public float getZoomTranslateY() {
        return this.zoomTranslateY;
    }

    public float[] getLabelRange() {
        return new float[]{this.minLabelDist, this.maxLabelDist};
    }

    void calcDistLabelRange() {
        this.minLabelDist = (float)(Math.asin(this.boundingBox[0] / this.R) * 57.29577951308232);
        this.maxLabelDist = (float)(Math.asin(this.boundingBox[1] / this.R) * 57.29577951308232);
    }

    public static float[] calcZoomScaleTranslate(float zoomXMin, float zoomXMax, float zoomYMin, float zoomYMax, float R, float minDist, float maxDist) {
        float longSide = Math.max(zoomYMax - zoomYMin, zoomXMax - zoomXMin);
        float zoomTranslateX = -1.0f * ((zoomXMax + zoomXMin) / 2.0f);
        float zoomTranslateY = (zoomYMax + zoomYMin) / 2.0f;
        if (zoomTranslateY + longSide / 2.0f > R) {
            zoomTranslateY = R - longSide / 2.0f;
        }
        if (zoomTranslateX + longSide / 2.0f > R) {
            zoomTranslateX = R - longSide / 2.0f;
        }
        float zoomScale = 2.0f * R / longSide;
        return new float[]{zoomScale, zoomTranslateX, zoomTranslateY, minDist, maxDist};
    }
}

