/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.NoArrivalException;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import java.util.ArrayList;
import java.util.List;

public abstract class SimpleSeismicPhase
implements SeismicPhase {
    public abstract List<Arrival> calcTimeExactDistance(double var1);

    @Override
    public List<ArrivalPathSegment> calcSegmentPaths(Arrival currArrival) throws NoArrivalException, SlownessModelException, TauModelException {
        return this.calcSegmentPaths(currArrival, new TimeDist(currArrival.getRayParam(), 0.0, 0.0, currArrival.getSourceDepth()), 0);
    }

    public List<ArrivalPathSegment> calcSegmentPaths(Arrival currArrival, TimeDist prevEnd, int prevIdx) throws NoArrivalException, SlownessModelException, TauModelException {
        int idx = prevIdx + 1;
        ArrayList<ArrivalPathSegment> segmentPaths = new ArrayList<ArrivalPathSegment>();
        int numSegments = currArrival.listPhaseSegments().size();
        SeismicPhaseSegment prevSeg = null;
        for (SeismicPhaseSegment seg : currArrival.listPhaseSegments()) {
            ArrivalPathSegment segPath = seg.calcPathTimeDist(currArrival, prevEnd, idx++, prevIdx + numSegments, prevSeg);
            segmentPaths.add(segPath);
            prevEnd = segPath.getPathEnd();
            prevSeg = seg;
        }
        return ArrivalPathSegment.adjustPath(segmentPaths, currArrival);
    }

    public abstract SimpleSeismicPhase interpolateSimplePhase(double var1);
}

