/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

public enum PhaseInteraction {
    START,
    TURN,
    REFLECT_UNDERSIDE,
    REFLECT_TOPSIDE,
    TRANSUP,
    TRANSDOWN,
    DIFFRACT,
    TRANSUPDIFFRACT,
    DIFFRACTTURN,
    HEAD,
    KMPS,
    SCATTER,
    SCATTER_DOWN,
    BACKSCATTER,
    BACKSCATTER_DOWN,
    END,
    END_DOWN,
    REFLECT_UNDERSIDE_CRITICAL,
    REFLECT_TOPSIDE_CRITICAL,
    FAIL;


    public static boolean isUpgoingActionBefore(PhaseInteraction endAction) {
        return !PhaseInteraction.isDowngoingActionBefore(endAction);
    }

    public static boolean isDowngoingActionBefore(PhaseInteraction endAction) {
        boolean isDowngoing;
        switch (endAction) {
            case TRANSUP: 
            case REFLECT_UNDERSIDE: 
            case REFLECT_UNDERSIDE_CRITICAL: 
            case END: {
                isDowngoing = false;
                break;
            }
            case TURN: 
            case TRANSDOWN: 
            case REFLECT_TOPSIDE: 
            case REFLECT_TOPSIDE_CRITICAL: 
            case END_DOWN: {
                isDowngoing = true;
                break;
            }
            case FAIL: 
            case START: {
                throw new IllegalArgumentException("End action cannot be FAIL or START: " + String.valueOf((Object)endAction));
            }
            default: {
                throw new IllegalArgumentException("End action case not yet impl: " + String.valueOf((Object)endAction));
            }
        }
        return isDowngoing;
    }

    public static boolean isUpgoingActionAfter(PhaseInteraction endAction) {
        return !PhaseInteraction.isDowngoingActionAfter(endAction);
    }

    public static boolean isDowngoingActionAfter(PhaseInteraction endAction) {
        boolean isDowngoing;
        switch (endAction) {
            case TRANSUP: 
            case END: 
            case TURN: 
            case REFLECT_TOPSIDE: 
            case REFLECT_TOPSIDE_CRITICAL: 
            case DIFFRACTTURN: {
                isDowngoing = false;
                break;
            }
            case REFLECT_UNDERSIDE: 
            case REFLECT_UNDERSIDE_CRITICAL: 
            case TRANSDOWN: 
            case END_DOWN: {
                isDowngoing = true;
                break;
            }
            case FAIL: 
            case START: {
                throw new IllegalArgumentException("End action cannot be FAIL or START: " + String.valueOf((Object)endAction));
            }
            default: {
                throw new IllegalArgumentException("End action case not yet impl: " + String.valueOf((Object)endAction));
            }
        }
        return isDowngoing;
    }

    public static int endOffset(PhaseInteraction endAction) {
        switch (endAction) {
            case TRANSUP: 
            case TRANSUPDIFFRACT: {
                return -1;
            }
            case TRANSDOWN: 
            case HEAD: {
                return 1;
            }
        }
        return 0;
    }
}

