/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.MomentMagnitude;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.cmdline.args.ModelArgs;
import java.util.List;
import picocli.CommandLine;

public class SeismicSourceArgs {
    Float mw = null;
    @CommandLine.Option(names={"--attenuationfreq"}, defaultValue="1.0", description={"attenuation frequency for amplitude calculations, default is ${DEFAULT-VALUE}"})
    Float attenuationFreq = null;
    @CommandLine.Option(names={"--numattenuationfreq"}, defaultValue="64", description={" number attenuation frequencies for amplitude calculations, default is ${DEFAULT-VALUE}"})
    int numFrequencies = 64;
    List<Float> strikeDipRake = null;
    public static final float DEFAULT_MW = 4.0f;
    public static final String DEFAULT_MW_STR = "4.0";
    public static final int DEFAULT_NUM_FREQUENCIES = 64;

    @CommandLine.Option(names={"--mw"}, defaultValue="4.0", description={"scale amplitude by source moment magnitude, default is ${DEFAULT-VALUE}"})
    public void setMw(float mw) {
        this.mw = Float.valueOf(mw);
    }

    public float getMw() {
        if (this.mw == null) {
            return MomentMagnitude.MAG4;
        }
        return this.mw.floatValue();
    }

    public double getMoment() {
        return MomentMagnitude.mw_to_N_m(this.getMw());
    }

    public float getAttenuationFrequency() {
        if (this.attenuationFreq == null) {
            return 1.0f;
        }
        return this.attenuationFreq.floatValue();
    }

    public int getNumFrequencies() {
        return this.numFrequencies;
    }

    @CommandLine.Option(names={"--strikediprake"}, paramLabel="strike dip rake", hideParamSyntax=true, arity="3", description={"fault strike, dip and rake for amplitude calculations. If not given radiation pattern is unity in all directions."})
    public void setStrikeDipRake(List<Float> sdr) {
        if (sdr.size() == 0) {
            this.strikeDipRake = null;
        } else if (sdr.size() != 3) {
            Object valStr = "";
            for (Float f : sdr) {
                valStr = (String)valStr + " " + f;
            }
            throw new IllegalArgumentException(String.format("Invalid number of params '%d' for option '--strikediprake': must give 3 values: %s", sdr.size(), valStr));
        }
        this.strikeDipRake = sdr;
    }

    public boolean hasStrikeDipRake() {
        return this.strikeDipRake != null;
    }

    public List<Float> getStrikeDipRake() {
        return this.strikeDipRake;
    }

    public double[] calcRadiationPat(double azimuth, double takeoffDeg) {
        if (this.hasStrikeDipRake()) {
            return SeismicSourceArgs.calcRadiationPatRadian((double)this.strikeDipRake.get(0).floatValue() * (Math.PI / 180), (double)this.strikeDipRake.get(1).floatValue() * (Math.PI / 180), (double)this.strikeDipRake.get(2).floatValue() * (Math.PI / 180), azimuth * (Math.PI / 180), takeoffDeg * (Math.PI / 180));
        }
        return new double[]{1.0, 1.0, 1.0};
    }

    public static double[] calcRadiationPatDeg(double strike, double dip, double rake, double azimuth, double takeoff) {
        return SeismicSourceArgs.calcRadiationPatRadian(strike * (Math.PI / 180), dip * (Math.PI / 180), rake * (Math.PI / 180), azimuth * (Math.PI / 180), takeoff * (Math.PI / 180));
    }

    public static double[] calcRadiationPatRadian(double strike, double dip, double rake, double azimuth, double takeoff) {
        double ih = takeoff;
        double phi_f = strike;
        double phi_r = azimuth;
        double phi_r_f = phi_r - phi_f;
        double theta = dip;
        double lam = rake;
        double Fp = (Math.cos(lam) * Math.sin(theta) * Math.sin(2.0 * phi_r_f) - Math.sin(lam) * Math.sin(2.0 * theta) * Math.sin(phi_r_f) * Math.sin(phi_r_f)) * Math.sin(ih) * Math.sin(ih) + (Math.sin(lam) * Math.cos(2.0 * theta) * Math.sin(phi_r_f) - Math.cos(lam) * Math.cos(theta) * Math.cos(phi_r_f)) * Math.sin(2.0 * ih) + Math.sin(lam) * Math.sin(2.0 * theta) * Math.cos(ih) * Math.cos(ih);
        double Fsv = (Math.sin(lam) * Math.cos(2.0 * theta) * Math.sin(phi_r_f) - Math.cos(lam) * Math.cos(theta) * Math.cos(phi_r_f)) * Math.cos(2.0 * ih) + 0.5 * Math.cos(lam) * Math.sin(theta) * Math.sin(2.0 * phi_r_f) * Math.sin(2.0 * ih) - 0.5 * Math.sin(lam) * Math.sin(2.0 * theta) * (1.0 + Math.sin(phi_r_f) * Math.sin(phi_r_f));
        double Fsh = (Math.cos(lam) * Math.cos(theta) * Math.sin(phi_r_f) + Math.sin(lam) * Math.cos(2.0 * theta) * Math.cos(phi_r_f)) * Math.cos(ih) + (Math.cos(lam) * Math.sin(theta) * Math.cos(2.0 * phi_r_f) - 0.5 * Math.sin(lam) * Math.sin(2.0 * theta) * Math.sin(2.0 * phi_r_f)) * Math.sin(ih);
        return new double[]{Fp, Fsv, Fsh};
    }

    public void validateArguments() {
        if (this.strikeDipRake != null && this.strikeDipRake.size() != 3) {
            throw new IllegalArgumentException("StrikeDipRake must have 3 values, but was: " + this.strikeDipRake.size());
        }
    }

    public void validateArgumentsForAmplitude(ModelArgs modelArgs, List<RayCalculateable> rayList) throws TauPException {
        if (modelArgs.getTauModel().getVelocityModel().densityIsDefault()) {
            throw new TauModelException("model " + modelArgs.getModelName() + " does not include density, but amplitude requires density.");
        }
        if (modelArgs.getTauModel().getVelocityModel().QIsDefault()) {
            throw new TauModelException("model " + modelArgs.getModelName() + " does not include Q, but amplitude requires Q.");
        }
        if (this.getStrikeDipRake() != null) {
            for (RayCalculateable rc : rayList) {
                if (rc.hasAzimuth()) continue;
                throw new IllegalArgumentException("Amplitude with Strike,Dip,Rake requires azimuth: " + rc);
            }
        }
    }
}

