/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.GsonBuilder;
import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.RayParamIndexRay;
import edu.sc.seis.TauP.ScatterArrivalFailException;
import edu.sc.seis.TauP.Scatterer;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeResult;
import edu.sc.seis.TauP.cmdline.TauP_AbstractRayTool;
import edu.sc.seis.TauP.cmdline.args.AmplitudeArgs;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import edu.sc.seis.TauP.cmdline.args.TextOutputTypeArgs;
import edu.sc.seis.TauP.gson.ArrivalSerializer;
import edu.sc.seis.TauP.gson.GsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="time", description={"Calculate travel times for seismic phases in an earth model."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Time
extends TauP_AbstractRayTool {
    @CommandLine.Option(names={"--rayp", "--onlyrayp"}, description={"only output the ray parameter"})
    protected boolean onlyPrintRayP = false;
    @CommandLine.Option(names={"--time", "--onlytime"}, description={"only output travel time"})
    protected boolean onlyPrintTime = false;
    @CommandLine.Option(names={"--first", "--onlyfirst"}, description={"only output the first arrival for each phase, no triplications"})
    protected boolean onlyFirst = false;
    @CommandLine.Mixin
    AmplitudeArgs sourceArgs = new AmplitudeArgs();
    @CommandLine.Option(names={"--rel"}, split=",", paramLabel="phase", description={"times relative to the first of the given phases"})
    protected List<String> relativePhaseName = new ArrayList<String>();
    protected List<SeismicPhase> relativePhaseList = new ArrayList<SeismicPhase>();
    @CommandLine.Mixin
    TextOutputTypeArgs outputTypeArgs = (TextOutputTypeArgs)this.abstractOutputTypeArgs;

    public AmplitudeArgs getSourceArgs() {
        return this.sourceArgs;
    }

    public boolean isWithAmplitude() {
        return this.getSourceArgs().isWithAmplitude();
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    public TauP_Time() {
        super(new TextOutputTypeArgs("text", "-"));
    }

    public TauP_Time(TauModel tMod) {
        this();
        this.setTauModel(tMod);
    }

    public TauP_Time(String modelName) throws TauModelException {
        this();
        this.modelArgs.setModelName(modelName);
    }

    @Override
    public List<Arrival> calcAll(List<SeismicPhase> phaseList, List<RayCalculateable> rayCalcList) throws TauPException {
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (SeismicPhase seismicPhase : phaseList) {
            ArrayList<Arrival> phaseArrivals = new ArrayList<Arrival>();
            for (RayCalculateable rayCalc : rayCalcList) {
                if (rayCalc.hasSourceDepth() && rayCalc.getSourceDepth().doubleValue() != seismicPhase.getSourceDepth() || rayCalc.hasReceiverDepth() && rayCalc.getReceiverDepth().doubleValue() != seismicPhase.getReceiverDepth()) continue;
                phaseArrivals.addAll(rayCalc.calculate(seismicPhase));
            }
            if (!this.onlyFirst) {
                arrivals.addAll(phaseArrivals);
                continue;
            }
            if (phaseArrivals.isEmpty()) continue;
            arrivals.add((Arrival)phaseArrivals.get(0));
        }
        if (!this.relativePhaseList.isEmpty()) {
            HashSet<Double> distList = new HashSet<Double>();
            for (Arrival arr : arrivals) {
                distList.add(arr.getModuloDist());
            }
            HashMap<Double, ArrayList<Arrival>> hashMap = new HashMap<Double, ArrayList<Arrival>>();
            for (Double dist : distList) {
                DistanceAngleRay distRay = DistanceRay.ofRadians(dist);
                distRay.setSourceArgs(this.sourceArgs);
                ArrayList<Arrival> relativeArrivals = new ArrayList<Arrival>();
                for (SeismicPhase relPhase : this.relativePhaseList) {
                    relativeArrivals.addAll(distRay.calculate(relPhase));
                }
                Arrival.sortArrivals(relativeArrivals);
                hashMap.put(dist, relativeArrivals);
            }
            block5: for (Arrival arrival : arrivals) {
                List relativeArrivals = (List)hashMap.get(arrival.getModuloDist());
                for (Arrival relArrival : relativeArrivals) {
                    if (relArrival.getSourceDepth() != arrival.getSourceDepth() || relArrival.getReceiverDepth() != arrival.getReceiverDepth()) continue;
                    arrival.setRelativeToArrival(relArrival);
                    continue block5;
                }
            }
        }
        return Arrival.sortArrivals(arrivals);
    }

    @Override
    public synchronized List<SeismicPhase> calcSeismicPhases(double sourceDepth, List<Double> receiverDepths, Scatterer scatterer) throws TauModelException {
        List<SeismicPhase> phaseList = super.calcSeismicPhases(sourceDepth, receiverDepths, scatterer);
        this.relativePhaseList = new ArrayList<SeismicPhase>();
        if (!this.relativePhaseName.isEmpty()) {
            for (Double recDepth : receiverDepths) {
                TauModel sourceReceiverTMod = this.modelArgs.depthCorrected(sourceDepth).splitBranch(recDepth);
                for (String sName : this.relativePhaseName) {
                    try {
                        List<SeismicPhase> calcRelPhaseList = SeismicPhaseFactory.createSeismicPhases(sName, sourceReceiverTMod, sourceDepth, recDepth, this.modelArgs.getScatterer(), this.isDEBUG());
                        this.relativePhaseList.addAll(calcRelPhaseList);
                    }
                    catch (ScatterArrivalFailException e) {
                        Alert.warning(e.getMessage(), "    Skipping this relative phase");
                        if (!this.isVerbose() && !this.isDEBUG()) continue;
                        e.printStackTrace();
                    }
                }
            }
        }
        return phaseList;
    }

    public GsonBuilder createGsonBuilder() {
        GsonBuilder gsonBld = GsonUtil.createGsonBuilder();
        gsonBld.registerTypeAdapter(Arrival.class, (Object)new ArrivalSerializer(false, false, this.isWithAmplitude()));
        return gsonBld;
    }

    @Override
    public void printResult(PrintWriter out, List<Arrival> arrivalList) throws IOException, TauPException {
        if (this.getOutputFormat().equals("json")) {
            TimeResult result = this.createTimeResult(this.isWithAmplitude(), this.sourceArgs, arrivalList);
            GsonBuilder gsonBld = this.createGsonBuilder();
            out.println(gsonBld.create().toJson((Object)result));
        } else {
            this.printResultText(out, arrivalList);
        }
        out.flush();
    }

    public void printResultText(PrintWriter out, List<Arrival> arrivalList) {
        TauP_Time.printArrivalsAsText(out, arrivalList, this.modelArgs.getModelName(), this.modelArgs.getSourceDepths(), this.modelArgs.getReceiverDepths(), this.getScatterer(), this.onlyPrintTime, this.onlyPrintRayP, this.isWithAmplitude(), this.sourceArgs, this.relativePhaseName);
    }

    public static void printArrivalsAsText(PrintWriter out, List<Arrival> arrivalList, String modelName, List<Double> sourceDepthList, List<Double> receiverDepthList, Scatterer scatterer, boolean onlyPrintTime, boolean onlyPrintRayP, boolean withAmplitude, SeismicSourceArgs sourceArgs, List<String> relativePhaseName) {
        int maxNameLength = 5;
        int maxPuristNameLength = 5;
        for (Arrival arrival : arrivalList) {
            if (arrival.getName().length() > maxNameLength) {
                maxNameLength = arrival.getName().length();
            }
            if (arrival.getPuristName().length() <= maxPuristNameLength) continue;
            maxPuristNameLength = arrival.getPuristName().length();
        }
        String phaseFormat = "%-" + maxNameLength + "s";
        String phasePuristFormat = "%-" + maxPuristNameLength + "s";
        if (!onlyPrintRayP && !onlyPrintTime) {
            String modelLine = "\nModel: " + modelName;
            if (scatterer != null && scatterer.depth != 0.0) {
                modelLine = modelLine + "  Scatter Depth: " + scatterer.depth + " km Dist: " + scatterer.getDistanceDegree();
            }
            if (withAmplitude) {
                out.println("    WARNING: \n      Amplitudes are an experimental feature and may not generate correct\n      results. They are provided in the hope that they are helpful and to\n      allow feedback from the community, but testing of their correctness\n      is ongoing.");
            }
            out.println(modelLine);
            String lineOne = "Distance   Depth   " + String.format(phaseFormat, "Phase") + "   Travel    Ray Param  Takeoff  Incident Station   Purist   " + String.format(phasePuristFormat, "Purist");
            String lineTwo = "  (deg)     (km)   " + String.format(phaseFormat, "Name ") + "   Time (s)  p (s/deg)   (deg)    (deg)    (km)     Distance  " + String.format(phasePuristFormat, "Name");
            if (withAmplitude) {
                lineOne = lineOne + "    Amp  ~" + Outputs.formatDistanceNoPad(sourceArgs.getMw()) + " Mw";
                lineTwo = lineTwo + "  Factor PSv   Sh";
            }
            if (!relativePhaseName.isEmpty()) {
                Object allRelPhase = "";
                for (String s : relativePhaseName) {
                    allRelPhase = (String)allRelPhase + s + ",";
                }
                allRelPhase = ((String)allRelPhase).substring(0, ((String)allRelPhase).length() - 1);
                lineOne = lineOne + " Relative to";
                for (int s = 0; s < (11 - ((String)allRelPhase).length()) / 2; ++s) {
                    lineTwo = lineTwo + " ";
                }
                lineTwo = lineTwo + "  " + String.format(phaseFormat, allRelPhase);
            }
            for (Arrival arrival : arrivalList) {
                if (!arrival.getRayCalculateable().hasDescription()) continue;
                lineOne = lineOne + " Description";
                lineTwo = lineTwo + "            ";
                break;
            }
            out.println(lineOne);
            out.println(lineTwo);
            StringBuilder dashes = new StringBuilder();
            for (int i = 0; i < Math.max(lineOne.length(), lineTwo.length()); ++i) {
                dashes.append("-");
            }
            out.write(dashes.append("\n").toString());
            Iterator<Arrival> iterator = arrivalList.iterator();
            while (iterator.hasNext()) {
                Arrival arrival;
                Arrival currArrival = arrival = iterator.next();
                out.print(Outputs.formatDistance(currArrival.getSearchDistDeg()));
                out.print(Outputs.formatDepth(currArrival.getPhase().getSourceDepth()) + "   ");
                out.print(String.format(phaseFormat, currArrival.getName()));
                out.print("  " + Outputs.formatTime(currArrival.getTime()) + "  " + Outputs.formatRayParam(currArrival.getRayParam() / 57.29577951308232) + "  ");
                out.print(Outputs.formatDistance(currArrival.getTakeoffAngleDegree()) + " ");
                out.print(Outputs.formatDistance(currArrival.getIncidentAngleDegree()) + " ");
                out.print(Outputs.formatDepth(currArrival.getReceiverDepth()) + " ");
                out.print(Outputs.formatDistance(currArrival.getDistDeg()));
                if (currArrival.getName().equals(currArrival.getPuristName())) {
                    out.print("   = ");
                } else {
                    out.print("   * ");
                }
                out.print(String.format(phasePuristFormat, currArrival.getPuristName()));
                if (withAmplitude) {
                    try {
                        double ampFactorPSV = currArrival.getAmplitudeFactorPSV();
                        double ampFactorSH = currArrival.getAmplitudeFactorSH();
                        out.print(" " + Outputs.formatAmpFactor(ampFactorPSV) + " " + Outputs.formatAmpFactor(ampFactorSH));
                    }
                    catch (SlownessModelException | TauModelException e) {
                        throw new RuntimeException("Should not happen", e);
                    }
                }
                if (!relativePhaseName.isEmpty()) {
                    if (currArrival.isRelativeToArrival()) {
                        out.print(" " + Outputs.formatTime(currArrival.getTime() - currArrival.getRelativeToArrival().getTime()));
                        out.print(" +" + String.format(phaseFormat, currArrival.getRelativeToArrival().getName()));
                    } else {
                        out.print(String.format(phaseFormat, " no arrival"));
                    }
                }
                if (arrival.getRayCalculateable().hasDescription()) {
                    out.print(" " + arrival.getRayCalculateable().getDescription());
                }
                out.println();
            }
        } else if (onlyPrintTime) {
            Iterator<Arrival> iterator = arrivalList.iterator();
            while (iterator.hasNext()) {
                Arrival arrival;
                Arrival currArrival = arrival = iterator.next();
                out.print((float)currArrival.getTime() + " ");
            }
            out.println();
        } else {
            Iterator<Arrival> iterator = arrivalList.iterator();
            while (iterator.hasNext()) {
                Arrival arrival;
                Arrival currArrival = arrival = iterator.next();
                out.write((float)(Math.PI / 180 * currArrival.getRayParam()) + " ");
            }
            out.println();
        }
        out.println();
        out.flush();
    }

    @Override
    public void init() throws TauPException {
        super.init();
    }

    @Override
    public void start() throws IOException, TauPException {
        List<RayCalculateable> distanceValues = this.getDistanceArgs().getRayCalculatables(this.sourceArgs);
        List<Arrival> arrivalList = this.calcAll(this.getSeismicPhases(), distanceValues);
        if (this.getDistanceArgs().isAllIndexRays()) {
            ArrayList<Arrival> indexArrivalList = new ArrayList<Arrival>();
            for (SeismicPhase phase : this.getSeismicPhases()) {
                if (!(phase instanceof SimpleSeismicPhase)) continue;
                SimpleSeismicPhase simpPhase = (SimpleSeismicPhase)phase;
                for (int i = 0; i < simpPhase.getNumRays(); ++i) {
                    indexArrivalList.addAll(new RayParamIndexRay(i).calculate(simpPhase));
                }
            }
            arrivalList.addAll(indexArrivalList);
        }
        PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        this.printResult(writer, arrivalList);
        writer.close();
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        super.validateArguments();
        this.sourceArgs.validateArguments();
        if (this.isWithAmplitude()) {
            this.sourceArgs.validateArgumentsForAmplitude(this.modelArgs, this.getDistanceArgs().getRayCalculatables(this.sourceArgs));
        }
    }
}

