/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.GsonBuilder;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.ScatteredArrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.cmdline.TauP_Time;
import edu.sc.seis.TauP.gson.ArrivalSerializer;
import edu.sc.seis.TauP.gson.ScatteredArrivalSerializer;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="pierce", description={"Calculate pierce points for phases at discontinuities in the model."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Pierce
extends TauP_Time {
    protected boolean onlyTurnPoints = false;
    protected boolean onlyRevPoints = false;
    protected boolean onlyUnderPoints = false;
    protected boolean onlyAddPoints = false;

    public TauP_Pierce() {
    }

    public TauP_Pierce(TauModel tMod) {
        super(tMod);
    }

    public TauP_Pierce(String modelName) throws TauModelException {
        super(modelName);
    }

    @CommandLine.Option(names={"--turn"}, description={"only prints bottom turning points, e.g. v"})
    public void setOnlyTurnPoints(boolean onlyTurnPoints) {
        this.onlyTurnPoints = onlyTurnPoints;
    }

    @CommandLine.Option(names={"--rev"}, description={"only prints underside and bottom turn points, e.g. ^ and v"})
    public void setOnlyRevPoints(boolean onlyRevPoints) {
        this.onlyRevPoints = onlyRevPoints;
    }

    @CommandLine.Option(names={"--under"}, description={"only prints underside reflection points, e.g. ^"})
    public void setOnlyUnderPoints(boolean onlyUnderPoints) {
        this.onlyUnderPoints = onlyUnderPoints;
    }

    @CommandLine.Option(names={"--nodiscon"}, description={"only prints pierce points for the depths added with -pierce"})
    public void setOnlyAddPoints(boolean onlyAddPoints) {
        this.onlyAddPoints = onlyAddPoints;
    }

    @CommandLine.Option(names={"--pierce"}, paramLabel="depth", description={"additional depth for calculating pierce points"}, split=",")
    public void setAddDepth(List<Double> addDepths) {
        this.modelArgs.setModelSplitDepths(addDepths);
    }

    public void appendAddDepths(String depthString) {
        this.modelArgs.unsetDepthCorrected();
        this.modelArgs.getModelSplitDepths().addAll(this.parseAddDepthsList(depthString));
    }

    protected List<Double> parseAddDepthsList(String depthList) {
        ArrayList<Double> out = new ArrayList<Double>();
        depthList = depthList.replace(' ', ',');
        for (String dstr : depthList.split(",")) {
            if (dstr.isEmpty()) continue;
            out.add(Double.parseDouble(dstr));
        }
        return out;
    }

    @Override
    public List<Arrival> calcAll(List<SeismicPhase> phaseList, List<RayCalculateable> rayCalcList) throws TauPException {
        List<Arrival> arrivalList = super.calcAll(phaseList, rayCalcList);
        for (Arrival arrival : arrivalList) {
            arrival.getPierce();
        }
        return arrivalList;
    }

    @Override
    public GsonBuilder createGsonBuilder() {
        GsonBuilder gsonBld = super.createGsonBuilder();
        gsonBld.registerTypeAdapter(Arrival.class, (Object)new ArrivalSerializer(true, false, this.isWithAmplitude()));
        gsonBld.registerTypeAdapter(ScatteredArrival.class, (Object)new ScatteredArrivalSerializer(true, false, this.isWithAmplitude()));
        return gsonBld;
    }

    @Override
    public void printResultText(PrintWriter out, List<Arrival> arrivalList) {
        this.printPierceAsText(out, arrivalList);
    }

    public void printPierceAsText(PrintWriter out, List<Arrival> arrivalList) {
        for (Arrival arrival : arrivalList) {
            out.println("> " + arrival.getCommentLine());
            TimeDist[] pierce = arrival.getPierce();
            double prevDepth = pierce[0].getDepth();
            for (int j = 0; j < pierce.length; ++j) {
                double calcDist = pierce[j].getDistDeg();
                double nextDepth = j < pierce.length - 1 ? pierce[j + 1].getDepth() : pierce[j].getDepth();
                if (!this.onlyTurnPoints && !this.onlyRevPoints && !this.onlyUnderPoints && !this.onlyAddPoints || this.onlyRevPoints && this.getScatterer() != null && pierce[j].getDepth() == this.getScatterer().depth && pierce[j].getDistDeg() == this.getScatterer().dist.getDegrees(arrival.getTauModel().getRadiusOfEarth()) || this.onlyAddPoints && this.isAddDepth(pierce[j].getDepth()) || this.onlyRevPoints && (prevDepth - pierce[j].getDepth()) * (pierce[j].getDepth() - nextDepth) < 0.0 || this.onlyTurnPoints && j != 0 && prevDepth - pierce[j].getDepth() <= 0.0 && pierce[j].getDepth() - nextDepth >= 0.0 || this.onlyUnderPoints && j != 0 && j != pierce.length - 1 && prevDepth - pierce[j].getDepth() >= 0.0 && pierce[j].getDepth() - nextDepth <= 0.0) {
                    out.write(Outputs.formatDistance(calcDist));
                    out.write(Outputs.formatDepth(pierce[j].getDepth()));
                    out.write(Outputs.formatTime(pierce[j].getTime()));
                    if (arrival.isLatLonable()) {
                        double[] latlon = arrival.getLatLonable().calcLatLon(calcDist, arrival.getDistDeg());
                        out.write("  " + Outputs.formatLatLon(latlon[0]) + "  " + Outputs.formatLatLon(latlon[1]));
                    }
                    out.write("\n");
                }
                prevDepth = pierce[j].getDepth();
            }
        }
    }

    public synchronized boolean isAddDepth(double depth) {
        for (Double aDouble : this.modelArgs.getModelSplitDepths()) {
            if (depth != aDouble) continue;
            return true;
        }
        return false;
    }
}

