/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.GsonBuilder;
import edu.sc.seis.TauP.PhaseDescribeResult;
import edu.sc.seis.TauP.PhaseDescription;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.cmdline.TauP_AbstractPhaseTool;
import edu.sc.seis.TauP.cmdline.args.TextOutputTypeArgs;
import edu.sc.seis.TauP.gson.GsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="phase", description={"Describe a seismic phase in the current model."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_PhaseDescribe
extends TauP_AbstractPhaseTool {
    public boolean dump = false;
    @CommandLine.Mixin
    TextOutputTypeArgs outputTypeArgs = (TextOutputTypeArgs)this.abstractOutputTypeArgs;

    public TauP_PhaseDescribe() {
        super(new TextOutputTypeArgs("text", "-"));
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public void validateArguments() throws TauModelException {
    }

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    @Override
    public void start() throws IOException, TauPException {
        PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        if (!this.getSeismicPhases().isEmpty()) {
            this.printResult(writer);
        } else {
            writer.println("No phases to describe.");
        }
        writer.close();
    }

    @Override
    public void destroy() throws TauPException {
    }

    public void printResult(PrintWriter writer) throws TauPException {
        if (this.getOutputFormat().equals("text")) {
            this.printResultText(writer);
        } else if (this.getOutputFormat().equals("json")) {
            ArrayList<PhaseDescription> phaseDesc = new ArrayList<PhaseDescription>();
            for (SeismicPhase sp : this.getSeismicPhases()) {
                phaseDesc.add(new PhaseDescription(sp));
            }
            PhaseDescribeResult result = new PhaseDescribeResult(this.modelArgs.getModelName(), this.modelArgs.getSourceDepths(), this.modelArgs.getReceiverDepths(), this.getPhaseArgs().parsePhaseNameList(), this.getScatterer(), phaseDesc);
            GsonBuilder gsonBld = GsonUtil.createGsonBuilder();
            writer.println(gsonBld.create().toJson((Object)result));
        } else {
            throw new IllegalArgumentException("Output format " + this.getOutputFormat() + " not recognized");
        }
        writer.flush();
    }

    public void printResultText(PrintWriter writer) throws TauPException {
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        for (SeismicPhase phase : phaseList) {
            writer.println(phase.describe());
            if (this.dump) {
                double[] dist = phase.getDist();
                double[] time = phase.getTime();
                double[] rayParam = phase.getRayParams();
                writer.println("Dist (deg)  Time (s)  RayParam(rad/sec)");
                writer.println("----------------------------------------");
                for (int i = 0; i < dist.length; ++i) {
                    writer.println(dist[i] * 57.29577951308232 + "  " + time[i] + "  " + rayParam[i]);
                }
                writer.println("----------------------------------------");
            }
            writer.println("--------");
        }
    }
}

