/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.args.TauModelOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.VelocityModelArgs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create .taup file from a velocity model."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Create
extends TauP_Tool {
    @CommandLine.ArgGroup(multiplicity="1", heading="Velocity Model %n")
    VelocityModelArgs inputFileArgs = new VelocityModelArgs();
    String directory = ".";
    TauModelOutputTypeArgs outputTypeArgs = (TauModelOutputTypeArgs)this.abstractOutputTypeArgs;
    VelocityModel vMod;
    protected boolean GUI = false;

    public TauP_Create() {
        super(new TauModelOutputTypeArgs("taup", "taup_create"));
        Alert.setGUI(this.GUI);
        try {
            this.toolProps = PropertyLoader.load();
        }
        catch (Exception e) {
            Alert.warning("Unable to load properties, using defaults.", e.getMessage());
            this.toolProps = new Properties();
        }
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setModelFilename(String modelFilename) {
        this.inputFileArgs.setModelFilename(modelFilename);
    }

    @Override
    public String getOutputFormat() {
        return "taup";
    }

    public void setVelFileType(String type) {
        this.inputFileArgs.setVelFileType(type);
    }

    @Override
    public void setDEBUG(boolean DEBUG) {
        super.setDEBUG(DEBUG);
    }

    public boolean getDEBUG() {
        return this.isDEBUG();
    }

    public void setVelocityModel(VelocityModel vMod) {
        this.vMod = vMod;
    }

    public void setMinDeltaP(float minDeltaP) {
        this.toolProps.setProperty("taup.create.minDeltaP", "" + minDeltaP);
    }

    public void setMaxDeltaP(float maxDeltaP) {
        this.toolProps.setProperty("taup.create.maxDeltaP", "" + maxDeltaP);
    }

    public void setMaxDepthInterval(float maxDepthInterval) {
        this.toolProps.setProperty("taup.create.maxDepthInterval", "" + maxDepthInterval);
    }

    public void setMaxRangeInterval(float maxRangeInterval) {
        this.toolProps.setProperty("taup.create.maxRangeInterval", "" + maxRangeInterval);
    }

    public void setMaxInterpError(float maxInterpError) {
        this.toolProps.setProperty("taup.create.maxInterpError", "" + maxInterpError);
    }

    public void setAllowInnerCoreS(boolean allowInnerCoreS) {
        this.toolProps.setProperty("taup.create.allowInnerCoreS", "" + allowInnerCoreS);
    }

    public VelocityModel loadVMod() throws IOException, VelocityModelException {
        File f;
        block7: {
            String file_sep = System.getProperty("file.separator");
            String filename = this.directory + file_sep + this.inputFileArgs.getModelFilename();
            f = new File(filename);
            if (this.isVerbose()) {
                Alert.debug("filename =" + this.directory + file_sep + this.inputFileArgs.getModelFilename());
            }
            try {
                this.vMod = VelocityModel.readVelocityFile(filename, this.inputFileArgs.getVelFileType());
            }
            catch (FileNotFoundException e) {
                if (!this.isDEBUG()) break block7;
                Alert.debug("Unable to load from directory " + filename);
            }
        }
        if (this.vMod == null) {
            this.vMod = TauModelLoader.loadVelocityModel(this.inputFileArgs.getModelFilename());
        }
        if (this.vMod == null) {
            throw new IOException("Velocity model file not found: " + this.inputFileArgs.getModelFilename() + ", tried internally and from file: " + f);
        }
        if (this.isVerbose()) {
            Alert.debug("Done reading velocity model.");
            Alert.debug("Radius of model " + this.vMod.getModelName() + " is " + this.vMod.getRadiusOfEarth());
        }
        if (this.isDEBUG()) {
            Alert.debug("velocity mode: " + this.vMod);
        }
        return this.vMod;
    }

    @Override
    public void validateArguments() throws TauModelException {
    }

    @Override
    public void start() throws SlownessModelException, TauModelException, IOException {
        try {
            if (this.isVerbose()) {
                Alert.debug("TauP_Create starting...");
            }
            String file_sep = System.getProperty("file.separator");
            TauModel tMod = TauModelLoader.createTauModel(this.vMod, this.toolProps);
            if (this.isDEBUG()) {
                Alert.debug("Done calculating Tau branches.");
            }
            if (this.isDEBUG()) {
                tMod.print();
            }
            String outFile = this.directory.equals(".") ? this.directory + file_sep + this.vMod.getModelName() + ".taup" : this.vMod.getModelName() + ".taup";
            tMod.writeModel(outFile);
            if (this.isVerbose()) {
                Alert.debug("Done Saving " + outFile);
            }
        }
        catch (IOException e) {
            Alert.warning("Tried to write!\n Caught IOException " + e.getMessage() + "\nDo you have write permission in this directory?");
            throw e;
        }
        finally {
            if (this.isVerbose()) {
                Alert.debug("Done!");
            }
        }
    }

    @Override
    public void init() throws TauPException {
        try {
            this.loadVMod();
        }
        catch (VelocityModelException e) {
            throw new TauPException("Problem with velocity model", e);
        }
        catch (IOException e) {
            throw new TauPException("Problem loading velocity model", e);
        }
    }

    @Override
    public void destroy() throws TauPException {
    }
}

