/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.VelocityModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class StdModelGenerator {
    public static void main(String[] args) throws IOException, TauPException {
        File inDir = new File(args[0]);
        File outDir = new File(args[1]);
        StdModelGenerator.createStandardModels(inDir, outDir);
    }

    public static void createStandardModels(File inDir, File outDir) throws IOException, TauPException {
        TauModel tMod;
        VelocityModel vMod;
        File inVModFile;
        ArrayList<String> tvelModelNames = new ArrayList<String>();
        tvelModelNames.add("iasp91");
        tvelModelNames.add("ak135");
        ArrayList<String> ndModelNames = new ArrayList<String>();
        ndModelNames.add("prem");
        ndModelNames.add("ak135fcont");
        ndModelNames.add("ak135favg");
        ndModelNames.add("ak135fsyngine");
        for (String modelName : tvelModelNames) {
            System.out.println(modelName);
            inVModFile = new File(inDir, modelName + ".tvel");
            vMod = VelocityModel.readTVelFile(inVModFile);
            vMod.setModelName(modelName);
            tMod = TauModelLoader.createTauModel(vMod);
            tMod.writeModel(new File(outDir, modelName + ".taup").getPath());
        }
        for (String modelName : ndModelNames) {
            System.out.println(modelName);
            inVModFile = new File(inDir, modelName + ".nd");
            vMod = VelocityModel.readNDFile(inVModFile);
            vMod.setModelName(modelName);
            tMod = TauModelLoader.createTauModel(vMod);
            tMod.writeModel(new File(outDir, modelName + ".taup").getPath());
        }
    }

    public static class StdModelCandidates
    extends ArrayList<String> {
        StdModelCandidates() {
            super(Arrays.asList("iasp91", "ak135", "prem", "ak135fcont", "ak135favg", "ak135fsyngine"));
        }
    }
}

