/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.ArrivalAmplitude;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.Complex;
import edu.sc.seis.TauP.CompositeSeismicPhase;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.NoArrivalException;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.ReflTransFreeSurface;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SimpleContigSeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Arrival {
    private final SimpleContigSeismicPhase simpleContigSeismicPhase;
    private final SeismicPhase phase;
    private final double time;
    private final double dist;
    private final double rayParam;
    private final int rayParamIndex;
    private final double dRPdDist;
    private RayCalculateable searchCalc;
    private final String name;
    private final String puristName;
    private final double sourceDepth;
    private final double receiverDepth;
    private TimeDist[] pierce;
    private List<ArrivalPathSegment> pathSegments;
    private final double incidentAngleRadian;
    private final double takeoffAngleRadian;
    private Arrival relativeToArrival = null;
    public static final double MANY_LAPS_PLUS_180 = 36180.0;
    public static final float DEFAULT_ATTENUATION_FREQUENCY = 1.0f;
    protected static final double KMtoM = 1000.0;
    protected static final double MgtoKg = 0.001;

    public Arrival(SeismicPhase phase, SimpleContigSeismicPhase simpleContigSeismicPhase, List<TimeDist> pierce, int rayParamIndex, double dRPdDist) {
        this(phase, simpleContigSeismicPhase, pierce.get(pierce.size() - 1).getTime(), pierce.get(pierce.size() - 1).getDistRadian(), pierce.get(pierce.size() - 1).getP(), rayParamIndex, DistanceRay.ofRadians(pierce.get(pierce.size() - 1).getP()), phase.getName(), phase.getPuristName(), phase.getSourceDepth(), phase.getReceiverDepth(), phase.calcTakeoffAngle(pierce.get(pierce.size() - 1).getP()), phase.calcIncidentAngle(pierce.get(pierce.size() - 1).getP()), dRPdDist);
        this.pierce = pierce.toArray(new TimeDist[0]);
    }

    public Arrival(SeismicPhase phase, SimpleContigSeismicPhase simpleContigSeismicPhase, double time, double dist, double rayParam, int rayParamIndex, double dRPdDist) {
        this(phase, simpleContigSeismicPhase, time, dist, rayParam, rayParamIndex, DistanceRay.ofRadians(dist), phase.getName(), phase.getPuristName(), phase.getSourceDepth(), phase.getReceiverDepth(), phase.calcTakeoffAngle(rayParam), phase.calcIncidentAngle(rayParam), dRPdDist);
    }

    public Arrival(SeismicPhase phase, SimpleContigSeismicPhase simpleContigSeismicPhase, double time, double dist, double rayParam, int rayParamIndex, RayCalculateable searchDist, String name, String puristName, double sourceDepth, double receiverDepth, double takeoffAngleRadian, double incidentAngleRadian, double dRPdDist) {
        if (!(phase instanceof SimpleContigSeismicPhase) && !(phase instanceof ScatteredSeismicPhase)) {
            throw new IllegalArgumentException("Phase must be SimpleContigSeismicPhase or ScatteredSeismicPhase");
        }
        if (Double.isNaN(time)) {
            throw new IllegalArgumentException("Time cannot be NaN");
        }
        if (rayParamIndex < 0) {
            throw new IllegalArgumentException("rayParamIndex cannot be negative: " + rayParamIndex);
        }
        this.phase = phase;
        this.time = time;
        this.dist = dist;
        this.rayParam = rayParam;
        this.rayParamIndex = rayParamIndex;
        this.searchCalc = searchDist;
        this.name = name;
        this.puristName = puristName;
        this.sourceDepth = sourceDepth;
        this.receiverDepth = receiverDepth;
        this.takeoffAngleRadian = takeoffAngleRadian;
        this.incidentAngleRadian = incidentAngleRadian;
        this.dRPdDist = dRPdDist;
        this.simpleContigSeismicPhase = simpleContigSeismicPhase;
        this.pierce = null;
        this.pathSegments = null;
    }

    public static List<Arrival> sortArrivals(List<Arrival> arrivals) {
        arrivals.sort(Comparator.comparingDouble(Arrival::getTime));
        return arrivals;
    }

    public static List<Arrival> onlyFirst(List<Arrival> arrivalList) {
        ArrayList<Arrival> first = new ArrayList<Arrival>();
        List<Arrival> copyList = new ArrayList<Arrival>(arrivalList);
        copyList = Arrival.sortArrivals(copyList);
        while (!copyList.isEmpty()) {
            Arrival early = copyList.get(0);
            first.add(early);
            copyList.remove(early);
            ArrayList<Arrival> samePhase = new ArrayList<Arrival>();
            for (Arrival a : copyList) {
                if (a.getPhase() != early.getPhase()) continue;
                samePhase.add(a);
            }
            copyList.removeAll(samePhase);
        }
        return first;
    }

    public String getCommentLine() {
        Object outName = this.getName();
        if (!this.getName().equals(this.getPuristName())) {
            outName = (String)outName + "(" + this.getPuristName() + ")";
        }
        String out = (String)outName + " at " + Outputs.formatTime(this.getTime()) + " seconds at " + Outputs.formatDistance(this.getDistDeg()) + " degrees for a " + Outputs.formatDepth(this.getSourceDepth()) + " km deep source in the " + this.getPhase().getTauModel().getModelName() + " model with rayParam " + Outputs.formatRayParam(Math.PI / 180 * this.getRayParam()) + " s/deg";
        if (this.getPhase().getReceiverDepth() != 0.0) {
            out = out + ", receiver at depth: " + this.getPhase().getReceiverDepth() + " km";
        }
        out = this.getRayCalculateable().hasDescription() ? out + ", " + this.getRayCalculateable().getDescription() + "." : out + ".";
        return out;
    }

    public SeismicPhase getPhase() {
        return this.phase;
    }

    public SimpleContigSeismicPhase getSimpleContigSeismicPhase() {
        if (this.phase instanceof SimpleContigSeismicPhase) {
            return (SimpleContigSeismicPhase)this.phase;
        }
        return this.simpleContigSeismicPhase;
    }

    public boolean isFromCompositePhase() {
        return this.phase instanceof CompositeSeismicPhase;
    }

    public List<SeismicPhaseSegment> listPhaseSegments() {
        if (this.phase instanceof SimpleContigSeismicPhase) {
            return ((SimpleContigSeismicPhase)this.phase).getPhaseSegments();
        }
        if (this.phase instanceof CompositeSeismicPhase) {
            return this.getSimpleContigSeismicPhase().getPhaseSegments();
        }
        throw new RuntimeException("SHould not happen, can't find phase segments for arrival");
    }

    public TauModel getTauModel() {
        return this.phase.getTauModel();
    }

    public double getTime() {
        return this.time;
    }

    public Duration getDuration() {
        return Duration.ofNanos(Math.round(this.getTime() * 1.0E9));
    }

    public double getDist() {
        return this.dist;
    }

    public double getDistDeg() {
        return 57.29577951308232 * this.getDist();
    }

    public double getModuloDist() {
        double moduloDist = this.getDist() % (Math.PI * 2);
        if (moduloDist > Math.PI) {
            moduloDist = Math.PI * 2 - moduloDist;
        }
        return moduloDist;
    }

    public double getModuloDistDeg() {
        return SeismicPhase.distanceTrim180(this.getDistDeg());
    }

    public void setSearchValue(RayCalculateable searchVal) {
        this.searchCalc = searchVal;
    }

    public double getSearchDistDeg() {
        if (this.searchCalc instanceof DistanceRay) {
            return ((DistanceRay)this.searchCalc).getDegrees(this.getTauModel().getRadiusOfEarth());
        }
        return this.getDistDeg();
    }

    public double getModuloSearchDistDeg() {
        return SeismicPhase.distanceTrim180(this.getSearchDistDeg());
    }

    public boolean isLongWayAround() {
        double shortWay = (36180.0 + this.getSearchDistDeg() - this.getDistDeg()) % 360.0 - 180.0;
        double longWay = (36180.0 + this.getSearchDistDeg() - (360.0 - this.getDistDeg())) % 360.0 - 180.0;
        return Math.abs(longWay) < Math.abs(shortWay);
    }

    public double getRayParam() {
        return this.rayParam;
    }

    public double getRayParamDeg() {
        return this.getRayParam() / 57.29577951308232;
    }

    public double getDRayParamDDelta() {
        return this.dRPdDist;
    }

    public double getDRayParamDDeltaDeg() {
        return this.dRPdDist / 57.29577951308232 / 57.29577951308232;
    }

    public ArrivalAmplitude calcAmplitude() throws SlownessModelException, TauModelException {
        return new ArrivalAmplitude(this);
    }

    public double getAmplitudeGeometricSpreadingFactor() throws TauModelException {
        double d = this.getEnergyGeometricSpreadingFactor();
        if (d < 0.0) {
            throw new RuntimeException("energy geo spread is neg " + this.getDistDeg() + " " + d);
        }
        return Math.sqrt(this.getEnergyGeometricSpreadingFactor());
    }

    public double getEnergyGeometricSpreadingFactor() {
        double out = 1.0;
        TauModel tMod = this.getTauModel();
        double R = tMod.radiusOfEarth;
        out *= this.getPhase().velocityAtSource() / ((R - this.getReceiverDepth()) * (R - this.getReceiverDepth()) * (R - this.getSourceDepth()));
        double takeoffRadian = this.getTakeoffAngleRadian();
        if (!this.getPhase().getInitialPhaseSegment().isDownGoing) {
            takeoffRadian = Math.PI - takeoffRadian;
        }
        out *= Math.tan(takeoffRadian) / Math.cos(this.getIncidentAngleRadian());
        out *= 1.0 / Math.sin(this.getModuloDist());
        double dRPdDist = this.getDRayParamDDelta();
        return out *= Math.abs(dRPdDist);
    }

    public double getEnergyFluxFactorReflTransPSV() throws VelocityModelException, SlownessModelException {
        try {
            return this.getPhase().calcEnergyFluxFactorReflTranPSV(this);
        }
        catch (NoArrivalException e) {
            throw new RuntimeException("Should never happen " + this.getName(), e);
        }
    }

    public double getEnergyFluxFactorReflTransSH() throws VelocityModelException, SlownessModelException {
        try {
            return this.getPhase().calcEnergyFluxFactorReflTranSH(this);
        }
        catch (NoArrivalException e) {
            throw new RuntimeException("Should never happen " + this.getName(), e);
        }
    }

    public double getAmplitudeFactorPSV() throws TauModelException, SlownessModelException {
        SeismicSourceArgs sourceArgs = this.getRayCalculateable().getSourceArgs();
        if (sourceArgs == null) {
            throw new TauModelException("sourceArgs is null, RayCalc:" + this.getRayCalculateable());
        }
        double ampFactor = this.getAmplitudeFactorPSV(sourceArgs.getMoment(), sourceArgs.getAttenuationFrequency(), sourceArgs.getNumFrequencies());
        if (sourceArgs.hasStrikeDipRake() && this.searchCalc.hasAzimuth()) {
            double[] radiationPattern = sourceArgs.calcRadiationPat(this.searchCalc.getAzimuth(), this.getTakeoffAngleDegree());
            double radTerm = 1.0;
            radTerm = this.getPhase().getInitialPhaseSegment().isPWave ? radiationPattern[0] : radiationPattern[1];
            ampFactor *= radTerm;
        } else if (sourceArgs.getStrikeDipRake() != null && this.searchCalc.hasAzimuth()) {
            throw new TauModelException("Amplitude with Strike-dip-rake requires azimuth");
        }
        return ampFactor;
    }

    public double getAmplitudeFactorPSV(double momentRate, double attenuationFrequency, int numFreq) throws TauModelException, SlownessModelException {
        double refltran = this.getEnergyFluxFactorReflTransPSV();
        double freeFactor = 1.0;
        if (this.getReceiverDepth() <= 1.0) {
            VelocityModel vMod = this.getTauModel().getVelocityModel();
            VelocityLayer top = vMod.getVelocityLayer(0);
            ReflTransFreeSurface rtFree = ReflTransFreeSurface.createReflTransFreeSurface(top.getTopPVelocity(), top.getTopSVelocity(), top.getTopDensity());
            Complex[] freeSurfRF = this.getPhase().getFinalPhaseSegment().isPWave ? rtFree.getFreeSurfaceReceiverFunP(this.getRayParam() / vMod.getRadiusOfEarth()) : rtFree.getFreeSurfaceReceiverFunSv(this.getRayParam() / vMod.getRadiusOfEarth());
            freeFactor = Complex.abs(Complex.sqrt(freeSurfRF[0].times(freeSurfRF[0].plus(freeSurfRF[1].times(freeSurfRF[1])))));
        }
        double geoSpread = this.getAmplitudeGeometricSpreadingFactor();
        double sourceVel = this.getPhase().velocityAtSource();
        double radiationTerm = this.calcRadiationTerm();
        double attenuation = 1.0;
        if (attenuationFrequency > 0.0) {
            attenuation = this.calcAttenuation(attenuationFrequency, numFreq);
        }
        return 1.0 * attenuation * freeFactor * momentRate * refltran * geoSpread / radiationTerm / 1000.0;
    }

    public double getAmplitudeFactorSH() throws TauModelException, VelocityModelException, SlownessModelException {
        SeismicSourceArgs sourceArgs = this.getRayCalculateable().getSourceArgs();
        double ampFactor = this.getAmplitudeFactorSH(sourceArgs.getMoment(), sourceArgs.getAttenuationFrequency(), sourceArgs.getNumFrequencies());
        if (sourceArgs.hasStrikeDipRake() && this.searchCalc.hasAzimuth()) {
            double[] radiationPattern = sourceArgs.calcRadiationPat(this.searchCalc.getAzimuth(), this.getTakeoffAngleDegree());
            ampFactor *= radiationPattern[2];
        } else if (sourceArgs.hasStrikeDipRake() && !this.searchCalc.hasAzimuth()) {
            throw new TauModelException("Amplitude with Strike-dip-rake requires azimuth: " + this.searchCalc);
        }
        return ampFactor;
    }

    public double getAmplitudeFactorSH(double momentRate, double attenuationFrequency, int numFreq) throws TauModelException, SlownessModelException {
        double refltran = this.getEnergyFluxFactorReflTransSH();
        if (refltran == 0.0) {
            return 0.0;
        }
        double geoSpread = this.getAmplitudeGeometricSpreadingFactor();
        double sourceVel = this.getPhase().velocityAtSource();
        double radiationTerm = this.calcRadiationTerm();
        double attenuation = 1.0;
        if (attenuationFrequency > 0.0) {
            attenuation = this.calcAttenuation(attenuationFrequency, numFreq);
        }
        double freeFactor = 1.0;
        if (this.getReceiverDepth() <= 1.0) {
            VelocityModel vMod = this.getTauModel().getVelocityModel();
            VelocityLayer top = vMod.getVelocityLayer(0);
            ReflTransFreeSurface rtFree = ReflTransFreeSurface.createReflTransFreeSurface(top.getTopPVelocity(), top.getTopSVelocity(), top.getTopDensity());
            freeFactor = rtFree.getFreeSurfaceReceiverFunSh(this.getRayParam() / vMod.getRadiusOfEarth());
        }
        return 1.0 * attenuation * freeFactor * momentRate * refltran * geoSpread / radiationTerm / 1000.0;
    }

    public double getRadiationPatternPSV() {
        SeismicSourceArgs sourceArgs = this.getRayCalculateable().getSourceArgs();
        double radTerm = 1.0;
        if (sourceArgs != null && sourceArgs.hasStrikeDipRake() && this.searchCalc.hasAzimuth()) {
            double[] radiationPattern = sourceArgs.calcRadiationPat(this.searchCalc.getAzimuth(), this.getTakeoffAngleDegree());
            radTerm = this.getPhase().getInitialPhaseSegment().isPWave ? radiationPattern[0] : radiationPattern[1];
        }
        return radTerm;
    }

    public double getRadiationPatternSH() {
        SeismicSourceArgs sourceArgs = this.getRayCalculateable().getSourceArgs();
        double radTerm = 1.0;
        if (sourceArgs != null && sourceArgs.hasStrikeDipRake() && this.searchCalc.hasAzimuth()) {
            double[] radiationPattern = sourceArgs.calcRadiationPat(this.searchCalc.getAzimuth(), this.getTakeoffAngleDegree());
            radTerm = this.getPhase().getInitialPhaseSegment().isPWave ? 0.0 : radiationPattern[2];
        }
        return radTerm;
    }

    public double getIncidentAngleDegree() {
        return this.getIncidentAngleRadian() * 57.29577951308232;
    }

    public double getIncidentAngleRadian() {
        return this.incidentAngleRadian;
    }

    public double getTakeoffAngleDegree() {
        return this.getTakeoffAngleRadian() * 57.29577951308232;
    }

    public double getTakeoffAngleRadian() {
        return this.takeoffAngleRadian;
    }

    public double velocityAtSource() {
        return this.getPhase().velocityAtSource();
    }

    public double radialSlownessAtSource() {
        double srcVel = this.velocityAtSource();
        double rofE = this.getTauModel().getRadiusOfEarth();
        double srcRadius = rofE - this.getSourceDepth();
        double radSlow = Math.sqrt(1.0 / (srcVel * srcVel) - this.getRayParam() * this.getRayParam() / (srcRadius * srcRadius));
        if (!Double.isFinite(radSlow) && Math.abs(1.0 / (srcVel * srcVel) - this.getRayParam() * this.getRayParam() / (srcRadius * srcRadius)) < 1.0E-6) {
            radSlow = 0.0;
        }
        return radSlow;
    }

    public double velocityAtReceiver() {
        return this.getPhase().velocityAtReceiver();
    }

    public double radialSlownessAtReceiver() {
        double recVel = this.velocityAtReceiver();
        double rofE = this.getTauModel().getRadiusOfEarth();
        double recRadius = rofE - this.getReceiverDepth();
        return Math.sqrt(1.0 / (recVel * recVel) - this.getRayParam() * this.getRayParam() / (recRadius * recRadius));
    }

    public int getRayParamIndex() {
        return this.rayParamIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getPuristName() {
        return this.puristName;
    }

    public double getSourceDepth() {
        return this.sourceDepth;
    }

    public double getReceiverDepth() {
        return this.receiverDepth;
    }

    public TimeDist getShallowestPierce() {
        TimeDist[] pierce = this.getPierce();
        TimeDist shallowest = pierce[0];
        for (TimeDist td : pierce) {
            if (!(td.getDepth() < shallowest.getDepth())) continue;
            shallowest = td;
        }
        return shallowest;
    }

    public TimeDist getDeepestPierce() {
        TimeDist[] pierce = this.getPierce();
        TimeDist deepest = pierce[0];
        for (TimeDist td : pierce) {
            if (!(td.getDepth() > deepest.getDepth())) continue;
            deepest = td;
        }
        return deepest;
    }

    public TimeDist getFurthestPierce() {
        TimeDist[] pierce = this.getPierce();
        TimeDist furthest = pierce[0];
        for (TimeDist td : pierce) {
            if (!(td.getDistRadian() > furthest.getDistRadian())) continue;
            furthest = td;
        }
        return furthest;
    }

    public TimeDist[] getPierce() {
        if (this.pierce == null) {
            try {
                this.pierce = this.getPhase().interpPierceTimeDist(this).toArray(new TimeDist[0]);
            }
            catch (NoArrivalException e) {
                throw new RuntimeException("Should never happen " + this.getName(), e);
            }
            catch (TauModelException e) {
                throw new RuntimeException("Should never happen " + this.getName(), e);
            }
        }
        return this.pierce;
    }

    public double calcFreeFactor() throws VelocityModelException {
        VelocityModel vMod = this.getTauModel().getVelocityModel();
        VelocityLayer top = vMod.getVelocityLayer(0);
        double freeFactor = 1.0;
        if (this.getReceiverDepth() <= 1.0) {
            ReflTransFreeSurface rtFree = ReflTransFreeSurface.createReflTransFreeSurface(top.getTopPVelocity(), top.getTopSVelocity(), top.getTopDensity());
            Complex[] freeSurfRF = this.getPhase().getFinalPhaseSegment().isPWave ? rtFree.getFreeSurfaceReceiverFunP(this.getRayParam() / vMod.getRadiusOfEarth()) : rtFree.getFreeSurfaceReceiverFunSv(this.getRayParam() / vMod.getRadiusOfEarth());
            freeFactor = Complex.abs(Complex.sqrt(freeSurfRF[0].times(freeSurfRF[0].plus(freeSurfRF[1].times(freeSurfRF[1])))));
        }
        return freeFactor;
    }

    public double calcAttenuation() {
        return this.calcAttenuation(this.getRayCalculateable().getSourceArgs().getAttenuationFrequency(), this.getRayCalculateable().getSourceArgs().getNumFrequencies());
    }

    public double calcAttenuation(double maxfreq, int N) {
        double tstar = this.calcTStar();
        double atten = 0.0;
        if (Double.isFinite(tstar)) {
            if (N == 0 || N == 1) {
                atten = Math.pow(Math.E, -Math.PI * maxfreq * tstar);
            } else {
                double deltaFreq = maxfreq / (double)(N - 1);
                for (int n = 0; n <= N; ++n) {
                    double freq = (double)n * deltaFreq;
                    atten += Math.pow(Math.E, -Math.PI * freq * tstar);
                }
                atten /= (double)N;
            }
        } else {
            atten = 1.0;
        }
        return atten;
    }

    public double calcTStar() {
        try {
            return this.getPhase().calcTstar(this);
        }
        catch (NoArrivalException e) {
            throw new RuntimeException("Should never happen " + this.getName(), e);
        }
    }

    public double[] calcRadiationPattern() {
        SeismicSourceArgs sourceArgs = this.getRayCalculateable().getSourceArgs();
        double[] radiationPattern = new double[]{1.0, 1.0, 1.0};
        if (sourceArgs != null && this.searchCalc.hasAzimuth()) {
            radiationPattern = sourceArgs.calcRadiationPat(this.searchCalc.getAzimuth(), this.getTakeoffAngleDegree());
        }
        return radiationPattern;
    }

    public double calcRadiationTerm() {
        double sourceVel = this.getPhase().velocityAtSource();
        double radiationTerm = Math.PI * 4 * this.getPhase().densityAtSource() * sourceVel * sourceVel * sourceVel * 1.0E12;
        return radiationTerm;
    }

    public double calcPathLength() {
        double length = 0.0;
        TauModel tMod = this.getTauModel();
        double R = tMod.radiusOfEarth;
        List<ArrivalPathSegment> pathSegList = this.getPathSegments();
        TimeDist prev = new TimeDist();
        for (ArrivalPathSegment pseg : pathSegList) {
            double radianInc;
            if (pseg.getPhaseSegment().getIsFlat()) {
                for (TimeDist td : pseg.getPath()) {
                    radianInc = td.getDistRadian() - prev.getDistRadian();
                    length += radianInc * (R - td.getDepth());
                }
                continue;
            }
            for (TimeDist td : pseg.getPath()) {
                radianInc = td.getDistRadian() - prev.getDistRadian();
                double radius_a = R - prev.getDepth();
                double radius_b = R - td.getDepth();
                double pathInc = Math.sqrt(radius_a * radius_a + radius_b * radius_b - 2.0 * radius_a * radius_b * Math.cos(radianInc));
                length += pathInc;
                prev = td;
            }
        }
        return length;
    }

    public TimeDist[] getPath() {
        if (this.pathSegments == null) {
            try {
                this.pathSegments = this.getPhase().calcSegmentPaths(this);
            }
            catch (NoArrivalException e) {
                throw new RuntimeException("Should never happen " + this.getName(), e);
            }
            catch (SlownessModelException e) {
                throw new RuntimeException("Should never happen " + this.getName(), e);
            }
            catch (TauModelException e) {
                throw new RuntimeException("Should never happen " + this.getName(), e);
            }
        }
        ArrayList pathList = new ArrayList();
        for (ArrivalPathSegment seg : this.pathSegments) {
            pathList.addAll(seg.path);
        }
        return pathList.toArray(new TimeDist[0]);
    }

    public List<ArrivalPathSegment> getPathSegments() {
        if (this.pathSegments == null) {
            try {
                this.pathSegments = this.getPhase().calcSegmentPaths(this);
            }
            catch (NoArrivalException e) {
                throw new RuntimeException("Should never happen " + this.getName(), e);
            }
            catch (SlownessModelException e) {
                throw new RuntimeException("Should never happen " + this.getName(), e);
            }
            catch (TauModelException e) {
                throw new RuntimeException("Should never happen " + this.getName(), e);
            }
        }
        return this.pathSegments;
    }

    public Arrival negateDistance() {
        return new Arrival(this.phase, this.simpleContigSeismicPhase, this.time, -1.0 * this.dist, this.rayParam, this.rayParamIndex, this.searchCalc, this.name, this.puristName, this.sourceDepth, this.receiverDepth, this.takeoffAngleRadian, this.incidentAngleRadian, this.dRPdDist);
    }

    public boolean isRelativeToArrival() {
        return this.relativeToArrival != null;
    }

    public Arrival getRelativeToArrival() {
        return this.relativeToArrival;
    }

    public void setRelativeToArrival(Arrival relativeToArrival) {
        this.relativeToArrival = relativeToArrival;
    }

    public static String toStringHeader() {
        return "Dist(deg)  Source  Name  Time    RayParam  Takeoff  Incident  PureDist  = PureName";
    }

    public String toString() {
        double moduloDistDeg = this.getModuloDistDeg();
        if (this.getSearchDistDeg() < 0.0) {
            moduloDistDeg *= -1.0;
        }
        String desc = Outputs.formatDistance(moduloDistDeg) + Outputs.formatDepth(this.getSourceDepth()) + "   " + this.getName() + "  " + Outputs.formatTime(this.getTime()) + "  " + Outputs.formatRayParam(Math.PI / 180 * this.getRayParam()) + "  " + Outputs.formatDistance(this.getTakeoffAngleDegree()) + " " + Outputs.formatDistance(this.getIncidentAngleDegree()) + " " + Outputs.formatDistance(this.getDistDeg()) + " " + this.getRayParamIndex();
        desc = this.getName().equals(this.getPuristName()) ? desc + "   = " : desc + "   * ";
        desc = desc + this.getPuristName();
        if (this.getRayCalculateable().hasDescription()) {
            desc = desc + " " + this.getRayCalculateable().getDescription();
        }
        return desc;
    }

    public TimeDist getSourceTimeDist() {
        return new TimeDist(this.getRayParam(), 0.0, 0.0, this.getSourceDepth());
    }

    public int getNumPiercePoints() {
        return this.getPierce().length;
    }

    public int getNumPathPoints() {
        int c = 0;
        for (ArrivalPathSegment seg : this.getPathSegments()) {
            c += seg.path.size();
        }
        return c;
    }

    public TimeDist getPiercePoint(int i) {
        return this.getPierce()[i];
    }

    public TimeDist getFirstPiercePoint(double depth) {
        for (TimeDist timeDist : this.getPierce()) {
            if (timeDist.getDepth() != depth) continue;
            return timeDist;
        }
        throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + depth);
    }

    public TimeDist getLastPiercePoint(double depth) {
        TimeDist piercepoint = null;
        for (TimeDist timeDist : this.getPierce()) {
            if (timeDist.getDepth() != depth) continue;
            piercepoint = timeDist;
        }
        if (piercepoint == null) {
            throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + depth);
        }
        return piercepoint;
    }

    public static Arrival getEarliestArrival(List<Arrival> arrivals) {
        double soonest = Double.MAX_VALUE;
        Arrival soonestArrival = null;
        for (Arrival a : arrivals) {
            if (!(a.getTime() < soonest)) continue;
            soonestArrival = a;
            soonest = a.getTime();
        }
        return soonestArrival;
    }

    public static Arrival getLatestArrival(List<Arrival> arrivals) {
        double latest = -1.7976931348623157E308;
        Arrival latestArrival = null;
        for (Arrival a : arrivals) {
            if (!(a.getTime() > latest)) continue;
            latestArrival = a;
            latest = a.getTime();
        }
        return latestArrival;
    }

    public static String CSVHeader() {
        return "Model,Distance (deg),Depth (km),Phase,Time (s),RayParam (deg/s),Takeoff Angle,Incident Angle,Purist Distance,Purist Name,Recv Depth";
    }

    public String asCSVRow() {
        String sep = ",";
        Object modelName = this.getTauModel().getModelName().replaceAll("\"", " ");
        if (((String)modelName).contains(",")) {
            modelName = "\"" + (String)modelName + "\"";
        }
        String line = (String)modelName + sep + Outputs.formatDistance(this.getModuloDistDeg()).trim() + sep + Outputs.formatDepth(this.getSourceDepth()).trim() + sep + this.getName().trim() + sep + Outputs.formatTime(this.getTime()).trim() + sep + Outputs.formatRayParam(this.getRayParamDeg()).trim() + sep + Outputs.formatDistance(this.getTakeoffAngleDegree()).trim() + sep + Outputs.formatDistance(this.getIncidentAngleDegree()).trim() + sep + Outputs.formatDistance(this.getDistDeg()).trim() + sep + this.getPuristName().trim() + this.receiverDepth;
        return line;
    }

    public RayCalculateable getRayCalculateable() {
        return this.searchCalc;
    }

    public boolean isLatLonable() {
        return this.getRayCalculateable() != null && this.getRayCalculateable().isLatLonable();
    }

    public LatLonable getLatLonable() {
        return this.getRayCalculateable() != null ? this.getRayCalculateable().getLatLonable() : null;
    }
}

