/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.sac;

import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.FDSNSourceIdException;
import edu.sc.seis.seisFile.sac.SacConstants;
import edu.sc.seis.seisFile.sac.SacHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;

public class SacTimeSeries {
    private SacHeader header;
    private float[] y;
    private float[] x;
    private float[] real;
    private float[] imaginary;
    private float[] amp;
    private float[] phase;
    private int numPtsRead = 0;

    public SacTimeSeries(SacHeader header) {
        this.header = header;
    }

    public SacTimeSeries(SacHeader header, float[] data) {
        this.header = header;
        header.setIftype(1);
        header.setLeven(1);
        this.setY(data);
    }

    public float[] getY() {
        return this.y;
    }

    public void setY(float[] y) {
        this.y = y;
        this.getHeader().setNpts(y.length);
        if (!SacConstants.isUndef(this.getHeader().getDelta()) && !SacConstants.isUndef(this.getHeader().getB())) {
            this.getHeader().setE(this.getHeader().getB() + (float)(y.length - 1) * this.getHeader().getDelta());
        }
    }

    public float[] getX() {
        return this.x;
    }

    public void setX(float[] x) {
        this.x = x;
    }

    public float[] getReal() {
        return this.real;
    }

    public void setReal(float[] real) {
        this.real = real;
    }

    public float[] getImaginary() {
        return this.imaginary;
    }

    public void setImaginary(float[] imaginary) {
        this.imaginary = imaginary;
    }

    public float[] getAmp() {
        return this.amp;
    }

    public void setAmp(float[] amp) {
        this.amp = amp;
    }

    public float[] getPhase() {
        return this.phase;
    }

    public void setPhase(float[] phase) {
        this.phase = phase;
    }

    public SacHeader getHeader() {
        return this.header;
    }

    public FDSNSourceId getSourceId() throws FDSNSourceIdException {
        return this.getHeader().getSourceId();
    }

    public void printHeader(PrintWriter out) {
        this.header.printHeader(out);
    }

    public int getNumPtsRead() {
        return this.numPtsRead;
    }

    public static SacTimeSeries read(String filename) throws FileNotFoundException, IOException {
        File sacFile = new File(filename);
        return SacTimeSeries.read(sacFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SacTimeSeries read(File sacFile) throws FileNotFoundException, IOException {
        if (sacFile.length() < 632L) {
            throw new IOException(sacFile.getName() + " does not appear to be a sac file! File size (" + sacFile.length() + " is less than sac's header size (632)");
        }
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(sacFile)));){
            SacHeader header = new SacHeader(dis);
            if (header.getLeven() == 1 && header.getIftype() == 1) {
                if (sacFile.length() != (long)(header.getNpts() * 4 + 632)) {
                    throw new IOException(sacFile.getName() + " does not appear to be a sac file! npts(" + header.getNpts() + ") * 4 + header(632) !=  file length=" + sacFile.length() + "\n  as linux: npts(" + SacHeader.swapBytes(header.getNpts()) + ")*4 + header(632) !=  file length=" + sacFile.length());
                }
            } else if (header.getLeven() == 1 || header.getIftype() == 3 || header.getIftype() == 2) {
                if (sacFile.length() != (long)(header.getNpts() * 4 * 2 + 632)) {
                    throw new IOException(sacFile.getName() + " does not appear to be a amph or rlim sac file! npts(" + header.getNpts() + ") * 4 *2 + header(632) !=  file length=" + sacFile.length() + "\n  as linux: npts(" + SacHeader.swapBytes(header.getNpts()) + ")*4*2 + header(632) !=  file length=" + sacFile.length());
                }
            } else if (header.getLeven() == 0 && sacFile.length() != (long)(header.getNpts() * 4 * 2 + 632)) {
                throw new IOException(sacFile.getName() + " does not appear to be a uneven sac file! npts(" + header.getNpts() + ") * 4 *2 + header(632) !=  file length=" + sacFile.length() + "\n  as linux: npts(" + SacHeader.swapBytes(header.getNpts()) + ")*4*2 + header(632) !=  file length=" + sacFile.length());
            }
            SacTimeSeries sacTimeSeries = SacTimeSeries.readData(header, dis);
            return sacTimeSeries;
        }
    }

    public static SacTimeSeries read(DataInput dis) throws IOException {
        SacHeader header = new SacHeader(dis);
        return SacTimeSeries.readData(header, dis);
    }

    protected static SacTimeSeries readData(SacHeader header, DataInput fis) throws IOException {
        float[] y = new float[header.getNpts()];
        SacTimeSeries.readDataArray(fis, y, header.getByteOrder());
        SacTimeSeries sac = new SacTimeSeries(header, y);
        if (header.getLeven() == 0 || header.getIftype() == 2 || header.getIftype() == 3) {
            float[] x = new float[header.getNpts()];
            SacTimeSeries.readDataArray(fis, x, header.getByteOrder());
            if (header.getIftype() == 2) {
                sac.real = y;
                sac.imaginary = x;
            }
            if (header.getIftype() == 3) {
                sac.amp = y;
                sac.phase = x;
            }
        }
        sac.numPtsRead = header.getNpts();
        return sac;
    }

    public static void readSomeData(DataInput dataIn, float[] data, boolean byteOrder) throws IOException {
        SacTimeSeries.readDataArray(dataIn, data, byteOrder);
    }

    public static int skipSamples(DataInput dataIn, int samplesToSkip) throws IOException {
        return dataIn.skipBytes(samplesToSkip * 4) / 4;
    }

    private static void readDataArray(DataInput fis, float[] d, boolean byteOrder) throws IOException {
        byte[] dataBytes = new byte[d.length * 4];
        int numAdded = 0;
        int i = 0;
        fis.readFully(dataBytes);
        while (numAdded < d.length) {
            if (!byteOrder) {
                d[numAdded++] = Float.intBitsToFloat(((dataBytes[i++] & 0xFF) << 0) + ((dataBytes[i++] & 0xFF) << 8) + ((dataBytes[i++] & 0xFF) << 16) + ((dataBytes[i++] & 0xFF) << 24));
                continue;
            }
            d[numAdded++] = Float.intBitsToFloat(((dataBytes[i++] & 0xFF) << 24) + ((dataBytes[i++] & 0xFF) << 16) + ((dataBytes[i++] & 0xFF) << 8) + ((dataBytes[i++] & 0xFF) << 0));
        }
    }

    public void write(String filename) throws FileNotFoundException, IOException {
        File f = new File(filename);
        this.write(f);
    }

    public void write(File file) throws FileNotFoundException, IOException {
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            this.header.writeHeader(dos);
            this.writeData(dos);
        }
    }

    public void writeData(DataOutput dos) throws IOException {
        int i;
        for (i = 0; i < this.header.getNpts(); ++i) {
            this.header.writeFloat(dos, this.y[i]);
        }
        if (this.header.getLeven() == 0 || this.header.getIftype() == 2 || this.header.getIftype() == 3) {
            for (i = 0; i < this.header.getNpts(); ++i) {
                this.header.writeFloat(dos, this.x[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendData(File outfile, float[] data) throws IOException {
        try (RandomAccessFile raFile = new RandomAccessFile(outfile, "rw");){
            SacHeader header = new SacHeader(raFile);
            if (header.getLeven() == 0 || header.getIftype() == 2 || header.getIftype() == 3) {
                raFile.close();
                throw new IOException("Can only append to evenly sampled sac files, ie only Y");
            }
            int origNpts = header.getNpts();
            header.setNpts(header.getNpts() + data.length);
            header.setE((float)(header.getNpts() - 1) * header.getDelta());
            raFile.seek(0L);
            header.writeHeader(raFile);
            raFile.skipBytes(origNpts * 4);
            if (!header.getByteOrder()) {
                for (int i = 0; i < data.length; ++i) {
                    raFile.writeInt(SacHeader.swapBytes(Float.floatToRawIntBits(data[i])));
                }
            } else {
                for (int i = 0; i < data.length; ++i) {
                    raFile.writeFloat(data[i]);
                }
            }
        }
    }
}

