/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.Location;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.DegreeFloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Equipment;
import edu.sc.seis.seisFile.fdsnws.stationxml.ExternalReference;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.MeterFloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Operator;
import edu.sc.seis.seisFile.fdsnws.stationxml.Site;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Station
extends BaseNodeType {
    Network network;
    String creationDate;
    String terminationDate;
    DegreeFloatType latitude;
    DegreeFloatType longitude;
    FloatType elevation;
    String name;
    String vault;
    MeterFloatType waterlevel;
    String geology;
    Site site;
    int totalNumChannels;
    int selectedNumChannels;
    String networkId;
    List<Channel> channelList = new ArrayList<Channel>();
    List<Equipment> equipmentList = new ArrayList<Equipment>();
    List<Operator> operatorList = new ArrayList<Operator>();
    List<ExternalReference> externalReferenceList = new ArrayList<ExternalReference>();

    public Station() {
    }

    public Station(Network network, String code) {
        this.setNetwork(network);
        this.code = code;
    }

    public Station(XMLEventReader reader, Network network) throws XMLStreamException, StationXMLException {
        this.network = network;
        StartElement startE = StaxUtil.expectStartElement("Station", reader);
        super.parseAttributes(startE);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (super.parseSubElement(elName, reader)) continue;
                if (elName.equals("Latitude")) {
                    this.latitude = new DegreeFloatType(reader, "Latitude");
                    continue;
                }
                if (elName.equals("Longitude")) {
                    this.longitude = new DegreeFloatType(reader, "Longitude");
                    continue;
                }
                if (elName.equals("Elevation")) {
                    this.elevation = new MeterFloatType(reader, "Elevation");
                    continue;
                }
                if (elName.equals("Site")) {
                    this.site = new Site(reader);
                    continue;
                }
                if (elName.equals("WaterLevel")) {
                    this.waterlevel = new MeterFloatType(reader, "WaterLevel");
                    continue;
                }
                if (elName.equals("Vault")) {
                    this.vault = StaxUtil.pullText(reader, "Vault");
                    continue;
                }
                if (elName.equals("Geology")) {
                    this.geology = StaxUtil.pullText(reader, "Geology");
                    continue;
                }
                if (elName.equals("Equipment")) {
                    this.equipmentList.add(new Equipment(reader));
                    continue;
                }
                if (elName.equals("Operator")) {
                    this.operatorList.add(new Operator(reader));
                    continue;
                }
                if (elName.equals("CreationDate")) {
                    this.creationDate = StaxUtil.pullText(reader, "CreationDate");
                    continue;
                }
                if (elName.equals("TerminationDate")) {
                    this.terminationDate = StaxUtil.pullText(reader, "TerminationDate");
                    continue;
                }
                if (elName.equals("TotalNumberChannels")) {
                    this.totalNumChannels = StaxUtil.pullInt(reader, "TotalNumberChannels");
                    continue;
                }
                if (elName.equals("SelectedNumberChannels")) {
                    this.selectedNumChannels = StaxUtil.pullInt(reader, "SelectedNumberChannels");
                    continue;
                }
                if (elName.equals("ExternalReference")) {
                    this.externalReferenceList.add(new ExternalReference(reader, "ExternalReference"));
                    continue;
                }
                if (elName.equals("Channel")) {
                    this.channelList.add(new Channel(reader, this));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public Network getNetwork() {
        return this.network;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public DegreeFloatType getLatitude() {
        return this.latitude;
    }

    public DegreeFloatType getLongitude() {
        return this.longitude;
    }

    public Location asLocation() {
        return new Location(this.getLatitudeFloat(), this.getLongitudeFloat());
    }

    public FloatType getElevation() {
        return this.elevation;
    }

    public float getLatitudeFloat() {
        return this.getLatitude().getValue();
    }

    public float getLongitudeFloat() {
        return this.getLongitude().getValue();
    }

    public float getElevationFloat() {
        return this.getElevation().getValue();
    }

    public Site getSite() {
        return this.site;
    }

    public int getTotalNumChannels() {
        return this.totalNumChannels;
    }

    public int getSelectedNumChannels() {
        return this.selectedNumChannels;
    }

    public List<Channel> getChannelList() {
        return this.channelList;
    }

    public String getTerminationDate() {
        return this.terminationDate;
    }

    public String getVault() {
        return this.vault;
    }

    public String getGeology() {
        return this.geology;
    }

    public String getNetworkCode() {
        return this.getNetwork().getNetworkCode();
    }

    public String getNetworkId() {
        return this.getNetwork().getNetworkId();
    }

    public String getStationCode() {
        return this.getCode();
    }

    public void setStationCode(String code) {
        this.setCode(code);
    }

    public List<Equipment> getEquipmentList() {
        return this.equipmentList;
    }

    public List<Operator> getOperatorList() {
        return this.operatorList;
    }

    public List<ExternalReference> getExternalReferenceList() {
        return this.externalReferenceList;
    }

    public String toString() {
        return this.getNetworkCode() + "." + this.getCode();
    }

    public void setNetwork(Network network) {
        this.network = network;
        this.networkId = network.getNetworkId();
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public void setTerminationDate(String terminationDate) {
        this.terminationDate = terminationDate;
    }

    public void setLatitude(float latitude) {
        this.setLatitude(new DegreeFloatType(latitude));
    }

    public void setLatitude(DegreeFloatType latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(float longitude) {
        this.setLongitude(new DegreeFloatType(longitude));
    }

    public void setLongitude(DegreeFloatType longitude) {
        this.longitude = longitude;
    }

    public void setElevation(float elevation) {
        this.setElevation(new FloatType(elevation, "meter"));
    }

    public void setElevation(FloatType elevation) {
        this.elevation = elevation;
    }

    public void setVault(String vault) {
        this.vault = vault;
    }

    public void setGeology(String geology) {
        this.geology = geology;
    }

    public void setSite(Site site) {
        this.site = site;
    }

    public void setTotalNumChannels(int totalNumChannels) {
        this.totalNumChannels = totalNumChannels;
    }

    public void setSelectedNumChannels(int selectedNumChannels) {
        this.selectedNumChannels = selectedNumChannels;
    }

    public void setChannelList(List<Channel> channelList) {
        this.channelList = channelList;
    }

    public void setEquipmentList(List<Equipment> equipmentList) {
        this.equipmentList = equipmentList;
    }

    public void appendEquipment(Equipment e) {
        this.equipmentList.add(e);
    }

    public void setOperatorList(List<Operator> operatorList) {
        this.operatorList = operatorList;
    }

    @Deprecated
    public void addOperator(Operator operator) {
        this.operatorList.add(operator);
    }

    public void appendOperator(Operator operator) {
        this.operatorList.add(operator);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MeterFloatType getWaterlevel() {
        return this.waterlevel;
    }

    public void setWaterlevel(MeterFloatType waterlevel) {
        this.waterlevel = waterlevel;
    }

    public void setWaterlevel(float level) {
        this.setWaterlevel(new MeterFloatType(level));
    }

    public void setExternalReferenceList(List<ExternalReference> externalReferenceList) {
        this.externalReferenceList = externalReferenceList;
    }

    public void appendExternalReference(ExternalReference extRef) {
        this.externalReferenceList.add(extRef);
    }

    public void associateInDb(Station sta) {
        this.setDbid(sta.getDbid());
    }
}

