/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.Person;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Operator {
    List<String> agencyList = new ArrayList<String>();
    List<Person> contactList = new ArrayList<Person>();
    String website;

    public Operator(String operName) {
        this.agencyList.add(operName);
    }

    public Operator(XMLEventReader reader) throws XMLStreamException, StationXMLException {
        StartElement startE = StaxUtil.expectStartElement("Operator", reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("Agency")) {
                    this.agencyList.add(StaxUtil.pullText(reader, "Agency"));
                    continue;
                }
                if (elName.equals("Contact")) {
                    this.contactList.add(new Person(reader, "Contact"));
                    continue;
                }
                if (elName.equals("WebSite")) {
                    this.website = StaxUtil.pullText(reader, "WebSite");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    @Deprecated
    public List<String> getAgencyList() {
        return this.agencyList;
    }

    public String getAgency() {
        return this.agencyList.get(0);
    }

    public List<Person> getContactList() {
        return this.contactList;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setAgency(String agency) {
        this.agencyList.clear();
        this.agencyList.add(agency);
    }

    public void appendContact(Person contact) {
        this.contactList.add(contact);
    }

    public void setWebsite(String website) {
        this.website = website;
    }
}

