/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Identifier {
    String value;
    String type = null;

    public Identifier(String value, String type) {
        this.value = value;
        this.type = type;
    }

    public Identifier(XMLEventReader reader, String tagName) throws StationXMLException, XMLStreamException {
        StartElement startE = StaxUtil.expectStartElement(tagName, reader);
        this.parseAttributes(startE);
        this.parseValue(reader);
    }

    void parseValue(XMLEventReader reader) throws StationXMLException, XMLStreamException {
        this.value = StaxUtil.pullContiguousText(reader);
    }

    void parseAttributes(StartElement startE) throws StationXMLException {
        String typeStr = StaxUtil.pullAttributeIfExists(startE, "type");
        if (typeStr != null) {
            this.type = typeStr;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

