/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.stationxml;

import edu.sc.seis.seisFile.Location;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.DataLogger;
import edu.sc.seis.seisFile.fdsnws.stationxml.DegreeFloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Equipment;
import edu.sc.seis.seisFile.fdsnws.stationxml.ExternalReference;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.fdsnws.stationxml.MeterFloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.PreAmplifier;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.SampleRateRatio;
import edu.sc.seis.seisFile.fdsnws.stationxml.Sensor;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.fdsnws.stationxml.StationXMLException;
import edu.sc.seis.seisFile.fdsnws.stationxml.Unit;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Channel
extends BaseNodeType {
    private Station station;
    private SampleRateRatio sampleRateRatio;
    private FloatType sampleRate;
    private FloatType clockDrift;
    private String clockDriftUnit = "SECONDS/SAMPLE";
    private Unit calibrationUnits;
    private Equipment sensor;
    private Equipment preAmplifier;
    private Equipment dataLogger;
    private List<Equipment> equipmentList = new ArrayList<Equipment>();
    private Response response;
    private String locCode;
    private String stationCode;
    private DegreeFloatType latitude;
    private DegreeFloatType longitude;
    private DegreeFloatType azimuth;
    private DegreeFloatType dip;
    private MeterFloatType waterlevel;
    private FloatType elevation;
    private FloatType depth;
    List<String> typeList = new ArrayList<String>();
    String storageFormat;
    List<ExternalReference> externalReferenceList = new ArrayList<ExternalReference>();
    public static final String EMPTY_LOC_CODE = "";

    public Channel() {
    }

    public Channel(Station station) {
        this.setStation(station);
        this.setLatitude(station.getLatitude());
        this.setLongitude(station.getLongitude());
        this.setElevation(station.getElevation());
        this.setDepth(0.0f);
    }

    public Channel(Station station, String locCode, String chanCode) {
        this(station);
        this.locCode = locCode;
        this.code = chanCode;
    }

    public Channel(Station station, String locCode, String chanCode, Instant startTime, Instant endTime) {
        this(station);
        this.locCode = locCode;
        this.code = chanCode;
        this.startDateTime = startTime;
        this.endDateTime = endTime;
    }

    public Channel(XMLEventReader reader, Station station) throws XMLStreamException, StationXMLException {
        this(station);
        StartElement startE = StaxUtil.expectStartElement("Channel", reader);
        super.parseAttributes(startE);
        this.locCode = Channel.fixLocCode(StaxUtil.pullAttribute(startE, "locationCode"));
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (super.parseSubElement(elName, reader)) continue;
                if (elName.equals("Latitude")) {
                    this.latitude = new DegreeFloatType(reader, "Latitude");
                    continue;
                }
                if (elName.equals("Longitude")) {
                    this.longitude = new DegreeFloatType(reader, "Longitude");
                    continue;
                }
                if (elName.equals("Elevation")) {
                    this.elevation = new MeterFloatType(reader, "Elevation");
                    continue;
                }
                if (elName.equals("Depth")) {
                    this.depth = new MeterFloatType(reader, "Depth");
                    continue;
                }
                if (elName.equals("Azimuth")) {
                    this.azimuth = new DegreeFloatType(reader, "Azimuth");
                    continue;
                }
                if (elName.equals("Dip")) {
                    this.dip = new DegreeFloatType(reader, "Dip");
                    continue;
                }
                if (elName.equals("Type")) {
                    this.typeList.add(StaxUtil.pullText(reader, "Type"));
                    continue;
                }
                if (elName.equals("SampleRate")) {
                    this.sampleRate = new FloatType(reader, "SampleRate", "hertz");
                    continue;
                }
                if (elName.equals("SampleRateRatio")) {
                    this.sampleRateRatio = new SampleRateRatio(reader);
                    continue;
                }
                if (elName.equals("StorageFormat")) {
                    this.storageFormat = StaxUtil.pullText(reader, "StorageFormat");
                    continue;
                }
                if (elName.equals("ClockDrift")) {
                    this.clockDrift = new FloatType(reader, "ClockDrift", this.clockDriftUnit);
                    continue;
                }
                if (elName.equals("CalibrationUnits")) {
                    this.calibrationUnits = new Unit(reader, "CalibrationUnits");
                    continue;
                }
                if (elName.equals("Sensor")) {
                    this.sensor = new Sensor(reader);
                    continue;
                }
                if (elName.equals("preAmplifier")) {
                    this.preAmplifier = new PreAmplifier(reader);
                    continue;
                }
                if (elName.equals("DataLogger")) {
                    this.dataLogger = new DataLogger(reader);
                    continue;
                }
                if (elName.equals("Equipment")) {
                    this.equipmentList.add(new Equipment(reader));
                    continue;
                }
                if (elName.equals("Response")) {
                    this.response = new Response(reader);
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            reader.nextEvent();
        }
    }

    public SampleRateRatio getSampleRateRatio() {
        return this.sampleRateRatio;
    }

    public FloatType getSampleRate() {
        return this.sampleRate;
    }

    public FloatType getClockDrift() {
        return this.clockDrift;
    }

    public String getClockDriftUnit() {
        return this.clockDriftUnit;
    }

    public Unit getCalibrationUnits() {
        return this.calibrationUnits;
    }

    public Equipment getSensor() {
        return this.sensor;
    }

    public Equipment getPreAmplifier() {
        return this.preAmplifier;
    }

    public Equipment getDataLogger() {
        return this.dataLogger;
    }

    public List<Equipment> getEquipment() {
        return this.equipmentList;
    }

    public Response getResponse() {
        return this.response;
    }

    public InstrumentSensitivity getInstrumentSensitivity() {
        return this.getResponse() != null ? this.getResponse().getInstrumentSensitivity() : null;
    }

    public void setInstrumentSensitivity(InstrumentSensitivity sensitivity) {
        if (this.getResponse() == null) {
            this.response = new Response();
        }
        this.response.setInstrumentSensitivity(sensitivity);
    }

    public String getChannelCode() {
        return this.getCode();
    }

    public void setChannelCode(String code) {
        this.setCode(code);
    }

    public String getLocCode() {
        return this.locCode;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public String getNetworkCode() {
        return this.getNetwork().getNetworkCode();
    }

    public String getNetworkId() {
        return this.getNetwork().getNetworkId();
    }

    public DegreeFloatType getLatitude() {
        return this.latitude;
    }

    public DegreeFloatType getLongitude() {
        return this.longitude;
    }

    public FloatType getElevation() {
        return this.elevation;
    }

    public FloatType getDepth() {
        return this.depth;
    }

    public float getLatitudeFloat() {
        return this.getLatitude().getValue();
    }

    public float getLongitudeFloat() {
        return this.getLongitude().getValue();
    }

    public float getElevationFloat() {
        return this.getElevation().getValue();
    }

    public float getDepthFloat() {
        return this.getDepth().getValue();
    }

    public Location asLocation() {
        return new Location(this.getLatitudeFloat(), this.getLongitudeFloat(), this.getDepthFloat());
    }

    public DegreeFloatType getAzimuth() {
        return this.azimuth;
    }

    public DegreeFloatType getDip() {
        return this.dip;
    }

    public List<String> getTypeList() {
        return this.typeList;
    }

    @Deprecated
    public String getStorageFormat() {
        return this.storageFormat;
    }

    public String toString() {
        return this.getNetworkCode() + "." + this.getStationCode() + "." + this.getLocCode() + "." + this.getCode();
    }

    public List<Equipment> getEquipmentList() {
        return this.equipmentList;
    }

    public void setEquipmentList(List<Equipment> equipmentList) {
        this.equipmentList = equipmentList;
    }

    public Station getStation() {
        return this.station;
    }

    public Network getNetwork() {
        try {
            return this.getStation().getNetwork();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void setStation(Station station) {
        this.station = station;
        this.stationCode = station.getStationCode();
    }

    public void setLongitude(float longitude) {
        this.setLongitude(new DegreeFloatType(longitude));
    }

    public void setLongitude(DegreeFloatType longitude) {
        this.longitude = longitude;
    }

    public void setSampleRateRatio(SampleRateRatio sampleRateRatio) {
        this.sampleRateRatio = sampleRateRatio;
    }

    public void setSampleRate(float sampleRate) {
        this.setSampleRate(new FloatType(sampleRate, "hertz"));
    }

    public void setSampleRate(FloatType sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setClockDrift(float clockDrift) {
        this.setClockDrift(new FloatType(clockDrift, "s/s"));
    }

    public void setClockDrift(FloatType clockDrift) {
        this.clockDrift = clockDrift;
    }

    public void setClockDriftUnit(String clockDriftUnit) {
        this.clockDriftUnit = clockDriftUnit;
    }

    public void setCalibrationUnits(Unit calibrationUnits) {
        this.calibrationUnits = calibrationUnits;
    }

    public void setSensor(Equipment sensor) {
        this.sensor = sensor;
    }

    public void setPreAmplifier(Equipment preAmplifier) {
        this.preAmplifier = preAmplifier;
    }

    public void setDataLogger(Equipment dataLogger) {
        this.dataLogger = dataLogger;
    }

    public void appendEquipment(Equipment equip) {
        this.equipmentList.add(equip);
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setLocCode(String locCode) {
        this.locCode = locCode;
    }

    public void setLatitude(float latitude) {
        this.setLatitude(new DegreeFloatType(latitude));
    }

    public void setLatitude(DegreeFloatType latitude) {
        this.latitude = latitude;
    }

    public void setElevation(float elevation) {
        this.setElevation(new FloatType(elevation, "meter"));
    }

    public void setElevation(FloatType elevation) {
        this.elevation = elevation;
    }

    public void setDepth(float depth) {
        this.setDepth(new FloatType(depth, "meter"));
    }

    public void setDepth(FloatType depth) {
        this.depth = depth;
    }

    public void setAzimuth(float azimuth) {
        this.setAzimuth(new DegreeFloatType(azimuth));
    }

    public void setAzimuth(DegreeFloatType azimuth) {
        this.azimuth = azimuth;
    }

    public void setDip(float dip) {
        this.setDip(new DegreeFloatType(dip));
    }

    public void setDip(DegreeFloatType dip) {
        this.dip = dip;
    }

    public MeterFloatType getWaterlevel() {
        return this.waterlevel;
    }

    public void setWaterlevel(MeterFloatType waterlevel) {
        this.waterlevel = waterlevel;
    }

    public void setWaterlevel(float level) {
        this.setWaterlevel(new MeterFloatType(level));
    }

    public void setTypeList(List<String> typeList) {
        this.typeList = typeList;
    }

    @Deprecated
    public void setStorageFormat(String storageFormat) {
        this.storageFormat = storageFormat;
    }

    public List<ExternalReference> getExternalReferenceList() {
        return this.externalReferenceList;
    }

    public void setExternalReferenceList(List<ExternalReference> externalReferenceList) {
        this.externalReferenceList = externalReferenceList;
    }

    public void appendExternalReference(ExternalReference extRef) {
        this.externalReferenceList.add(extRef);
    }

    public static String fixLocCode(String locCode) {
        String out = locCode;
        if (locCode == null) {
            out = EMPTY_LOC_CODE;
        } else if ((out = out.trim()).isEmpty() || out.equals("--")) {
            out = EMPTY_LOC_CODE;
        }
        return out;
    }

    public void associateInDb(Channel indb) {
        this.setDbid(indb.getDbid());
    }
}

