/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import edu.sc.seis.TauP.Isochron;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.WavefrontPathSegment;
import java.lang.reflect.Type;

public class IsochronSerializer
implements JsonSerializer<Isochron> {
    public JsonElement serialize(Isochron src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("time", (Number)src.getTime());
        JsonArray wavefrontArr = new JsonArray(src.getWavefront().size());
        for (WavefrontPathSegment seg : src.getWavefront()) {
            JsonObject jsonObject = new JsonObject();
            wavefrontArr.add((JsonElement)jsonObject);
            jsonObject.addProperty("time", (Number)seg.getTimeVal());
            jsonObject.addProperty("phase", seg.getPhase().getName());
            jsonObject.addProperty("model", seg.getPhase().getTauModel().getModelName());
            jsonObject.addProperty("sourcedepth", (Number)seg.getPhase().getSourceDepth());
            jsonObject.addProperty("receiverdepth", (Number)seg.getPhase().getReceiverDepth());
            if (seg.getPhase() instanceof ScatteredSeismicPhase) {
                ScatteredSeismicPhase scatPhase = (ScatteredSeismicPhase)seg.getPhase();
                jsonObject.add("scatter", context.serialize((Object)scatPhase.getScatterer()));
            }
            jsonObject.addProperty("wavetype", seg.getWavetypeStr());
            jsonObject.add("segments", (JsonElement)seg.asJsonObject());
        }
        obj.add("wavefronts", (JsonElement)wavefrontArr);
        return obj;
    }
}

