/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.cmdline.args.AbstractOutputTypeArgs;
import picocli.CommandLine;

public class TextOutputTypeArgs
extends AbstractOutputTypeArgs {
    @CommandLine.ArgGroup(heading="Output Type:%n")
    TextOutputType outputType = new TextOutputType();

    public TextOutputTypeArgs(String defaultFormat, String filebase) {
        super(filebase);
        this.setOutputFormat(defaultFormat);
    }

    public boolean isText() {
        return this.outputType._isText;
    }

    public boolean isJSON() {
        return this.outputType._isJSON;
    }

    @Override
    public String getOutputFormat() {
        if (this.isJSON()) {
            return "json";
        }
        return "text";
    }

    @Override
    public void setOutputFormat(String oType) {
        this.outputType._isText = false;
        this.outputType._isJSON = false;
        if (oType.equalsIgnoreCase("text")) {
            this.outputType._isText = true;
        } else if (oType.equalsIgnoreCase("json")) {
            this.outputType._isText = true;
        } else {
            throw new IllegalArgumentException("output type " + oType + " not recognized.");
        }
    }

    @Override
    public String getOutFileExtension() {
        String extention = "text";
        if (this.isJSON()) {
            extention = "json";
        }
        return extention;
    }

    static class TextOutputType {
        @CommandLine.Option(names={"--text"}, required=true, description={"outputs as Text"})
        boolean _isText = false;
        @CommandLine.Option(names={"--json"}, required=true, description={"outputs as JSON"})
        boolean _isJSON = false;

        TextOutputType() {
        }
    }
}

