/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.cmdline.args.AbstractOutputTypeArgs;
import picocli.CommandLine;

public class TableOutputTypeArgs
extends AbstractOutputTypeArgs {
    @CommandLine.ArgGroup(heading="Output Type:%n")
    TableOutputType outputType = new TableOutputType();
    String outFileBase = "taup_table";

    public TableOutputTypeArgs(String defaultFormat, String filebase) {
        super(filebase);
        this.setOutputFormat(defaultFormat);
    }

    public boolean isText() {
        return this.outputType._isText;
    }

    public boolean isJSON() {
        return this.outputType._isJSON;
    }

    public boolean isCSV() {
        return this.outputType._isCSV;
    }

    public boolean isLocsat() {
        return this.outputType._isLocsat;
    }

    @Override
    public void setOutputFormat(String oType) {
        this.outputType._isText = false;
        this.outputType._isJSON = false;
        this.outputType._isCSV = false;
        this.outputType._isLocsat = false;
        if (oType.equalsIgnoreCase("text") || oType.equalsIgnoreCase("generic")) {
            this.outputType._isText = true;
        } else if (oType.equalsIgnoreCase("json")) {
            this.outputType._isJSON = true;
        } else if (oType.equalsIgnoreCase("csv")) {
            this.outputType._isCSV = true;
        } else if (oType.equalsIgnoreCase("locsat")) {
            this.outputType._isLocsat = true;
        } else {
            throw new IllegalArgumentException("output type " + oType + " not recognized.");
        }
    }

    @Override
    public String getOutputFormat() {
        if (this.isJSON()) {
            return "json";
        }
        if (this.isCSV()) {
            return "csv";
        }
        if (this.isLocsat()) {
            return "locsat";
        }
        return "text";
    }

    @Override
    public String getOutFileExtension() {
        if (this.extension != null && !this.extension.isEmpty()) {
            return this.extension;
        }
        String calcExt = "text";
        if (this.isJSON()) {
            calcExt = "json";
        }
        if (this.isCSV()) {
            calcExt = "csv";
        }
        if (this.isLocsat()) {
            calcExt = "locsat";
        }
        return calcExt;
    }

    static class TableOutputType {
        @CommandLine.Option(names={"--text", "--generic"}, required=true, description={"outputs as Text"})
        boolean _isText = true;
        @CommandLine.Option(names={"--json"}, required=true, description={"outputs as JSON"})
        boolean _isJSON = false;
        @CommandLine.Option(names={"--csv"}, required=true, description={"outputs as CSV"})
        boolean _isCSV = false;
        @CommandLine.Option(names={"--locsat"}, required=true, description={"outputs as Locsat"})
        boolean _isLocsat = false;

        TableOutputType() {
        }
    }
}

