/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.PhaseParseException;
import edu.sc.seis.TauP.TauPConfig;
import edu.sc.seis.TauP.cmdline.TauP_AbstractPhaseTool;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

public class PhaseArgs {
    public static final String DEFAULT_PHASES = "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS";
    TauP_AbstractPhaseTool tool;
    List<String> phaseNames = new ArrayList<String>();
    List<String> phaseFileList = new ArrayList<String>();

    public static List<String> extractPhaseNames(String phaseNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (String phaseName : PhaseArgs.splitPhaseNameList(phaseNames)) {
            if (phaseName.equalsIgnoreCase("ttp") || phaseName.equalsIgnoreCase("tts") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttall")) {
                if (phaseName.equalsIgnoreCase("ttp") || phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                    names.add("p");
                    names.add("P");
                    names.add("Pn");
                    names.add("Pdiff");
                    names.add("PKP");
                    names.add("PKiKP");
                    names.add("PKIKP");
                }
                if (phaseName.equalsIgnoreCase("tts") || phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                    names.add("s");
                    names.add("S");
                    names.add("Sn");
                    names.add("Sdiff");
                    names.add("SKS");
                    names.add("SKIKS");
                }
                if (phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                    names.add("PcP");
                    names.add("pP");
                    names.add("pPdiff");
                    names.add("pPKP");
                    names.add("pPKIKP");
                    names.add("pPKiKP");
                    names.add("sP");
                    names.add("sPdiff");
                    names.add("sPKP");
                    names.add("sPKIKP");
                    names.add("sPKiKP");
                }
                if (phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                    names.add("sS");
                    names.add("sSdiff");
                    names.add("sSKS");
                    names.add("sSKIKS");
                    names.add("ScS");
                    names.add("pS");
                    names.add("pSdiff");
                    names.add("pSKS");
                    names.add("pSKIKS");
                }
                if (phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                    names.add("ScP");
                    names.add("SKP");
                    names.add("SKIKP");
                    names.add("PKKP");
                    names.add("PKIKKIKP");
                    names.add("SKKP");
                    names.add("SKIKKIKP");
                    names.add("PP");
                    names.add("PKPPKP");
                    names.add("PKIKPPKIKP");
                }
                if (!phaseName.equalsIgnoreCase("ttall")) continue;
                names.add("SKiKP");
                names.add("PP");
                names.add("ScS");
                names.add("PcS");
                names.add("PKS");
                names.add("PKIKS");
                names.add("PKKS");
                names.add("PKIKKIKS");
                names.add("SKKS");
                names.add("SKIKKIKS");
                names.add("SKSSKS");
                names.add("SKIKSSKIKS");
                names.add("SS");
                names.add("SP");
                names.add("PS");
                continue;
            }
            names.add(phaseName);
        }
        return names;
    }

    public static String[] splitPhaseNameList(String phaseList) {
        phaseList = phaseList.trim();
        phaseList = phaseList.replace(' ', ',');
        if ((phaseList = phaseList.replaceAll(",,+", ",")).startsWith(",")) {
            phaseList = phaseList.substring(1);
        }
        if (phaseList.isEmpty()) {
            return new String[0];
        }
        if (phaseList.charAt(phaseList.length() - 1) == ',') {
            phaseList = phaseList.substring(0, phaseList.length() - 1);
        }
        return phaseList.split(",");
    }

    public void setTool(TauP_AbstractPhaseTool tool) {
        this.tool = tool;
    }

    @CommandLine.Option(names={"-p", "--phase", "--ph"}, paramLabel="phase", split=",", description={"seismic phase names"})
    public void setPhaseNames(List<String> phaseNamesStr) {
        if (this.tool != null) {
            this.tool.clearPhaseNames();
        }
        for (String phArg : phaseNamesStr) {
            for (String ph : PhaseArgs.extractPhaseNames(phArg)) {
                boolean found = false;
                for (String prev : this.phaseNames) {
                    if (!prev.equals(ph)) continue;
                    found = true;
                }
                if (found) continue;
                this.phaseNames.add(ph);
            }
        }
    }

    @CommandLine.Option(names={"--phasefile"}, description={"read list of phase names from file"})
    public void setPhaseFiles(List<String> phaseFile) {
        if (this.tool != null) {
            this.tool.clearPhaseNames();
        }
        this.phaseFileList = phaseFile;
    }

    public List<PhaseName> parsePhaseNameList() throws PhaseParseException {
        ArrayList<PhaseName> phases = new ArrayList<PhaseName>();
        if (this.isEmpty()) {
            for (String pStr : PhaseArgs.extractPhaseNames(DEFAULT_PHASES)) {
                phases.add(new PhaseName(pStr));
            }
        } else {
            for (String pStr : this.phaseNames) {
                phases.add(new PhaseName(pStr));
            }
            for (String filename : this.phaseFileList) {
                List<String> pList;
                try {
                    pList = this.readPhaseFile(filename);
                }
                catch (IOException e) {
                    throw new PhaseParseException("Unable to parse file: " + filename, e);
                }
                for (String pStr : pList) {
                    phases.add(new PhaseName(pStr));
                }
            }
        }
        return phases;
    }

    public static String getPhaseNamesAsString(List<PhaseName> phaseNameList) {
        if (phaseNameList.isEmpty()) {
            return "";
        }
        StringBuffer phases = new StringBuffer();
        phases.append(phaseNameList.get(0).getName());
        for (PhaseName phaseName : phaseNameList.subList(1, phaseNameList.size())) {
            phases.append(",").append(phaseName.getName());
        }
        return phases.toString();
    }

    protected List<String> readPhaseFile(String filename) throws IOException {
        ArrayList<String> out = new ArrayList<String>();
        FileReader fileIn = new FileReader(filename);
        StreamTokenizer tokenIn = new StreamTokenizer(fileIn);
        tokenIn.commentChar(35);
        tokenIn.slashStarComments(true);
        tokenIn.slashSlashComments(true);
        tokenIn.wordChars(94, 94);
        tokenIn.wordChars(48, 57);
        tokenIn.wordChars(46, 46);
        tokenIn.wordChars(91, 91);
        tokenIn.wordChars(93, 93);
        while (tokenIn.nextToken() != -1) {
            if (tokenIn.sval != null) {
                out.add(tokenIn.sval);
                continue;
            }
            if (!TauPConfig.DEBUG) continue;
            Alert.info("Token.sval was null! nval=" + tokenIn.nval);
        }
        return out;
    }

    public boolean isEmpty() {
        return this.phaseNames.isEmpty() && this.phaseFileList.isEmpty();
    }
}

