/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.Scatterer;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.cmdline.args.TableModelArgs;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

public class ModelArgs {
    protected TauModel tMod;
    protected transient TauModel tModDepth;
    protected List<Double> modelSplitDepths = new ArrayList<Double>();
    @CommandLine.ArgGroup(heading="Model Args %n", exclusive=false)
    ModelArgsInner modelArgsInner = new ModelArgsInner();

    public String getModelName() {
        return this.modelArgsInner.getModelName();
    }

    public void setModelName(String modelName) {
        this.unsetDepthCorrected();
        this.tMod = null;
        this.modelArgsInner.setModelName(modelName);
    }

    public List<Double> getSourceDepths() {
        return this.modelArgsInner.sourceDepth;
    }

    public void setSourceDepths(List<Double> depths) {
        this.modelArgsInner.sourceDepth = depths;
    }

    public List<Double> getReceiverDepths() {
        return this.modelArgsInner.getReceiverDepths();
    }

    public void setReceiverDepths(List<Double> depths) {
        this.modelArgsInner.receiverDepths = depths;
    }

    public static String depthsToString(List<Double> depths) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (Double d : depths) {
            if (!first) {
                buf.append(", ");
            }
            buf.append(d);
            first = false;
        }
        return buf.toString();
    }

    public Scatterer getScatterer() {
        return this.modelArgsInner.getScatterer();
    }

    public void setScatterer(double depth, double dist) {
        this.modelArgsInner.setScatterer(depth, dist);
    }

    public TauModel getTauModel() throws TauModelException {
        if (this.tMod == null) {
            this.tMod = this.modelArgsInner.getTauModel();
        }
        return this.tMod;
    }

    public void setTMod(TauModel tMod) {
        this.unsetDepthCorrected();
        this.tMod = tMod;
    }

    public void unsetDepthCorrected() {
        this.tModDepth = null;
    }

    public void setModelSplitDepths(List<Double> modelSplitDepths) {
        this.modelSplitDepths = modelSplitDepths;
    }

    public List<Double> getModelSplitDepths() {
        return this.modelSplitDepths;
    }

    public TauModel depthCorrected(double sourceDepth) throws TauModelException {
        if (this.tModDepth == null) {
            this.tModDepth = this.getTauModel();
        }
        if (this.tModDepth.getSourceDepth() != sourceDepth) {
            this.tModDepth = this.getTauModel().depthCorrect(sourceDepth);
            if (this.getScatterer() != null && !this.tModDepth.isBranchDepth(this.getScatterer().depth)) {
                this.tModDepth = this.tModDepth.splitBranch(this.getScatterer().depth);
            }
            for (Double d : this.modelSplitDepths) {
                if (this.tModDepth.isBranchDepth(d)) continue;
                this.tModDepth = this.tModDepth.splitBranch(d);
            }
        }
        return this.tModDepth;
    }

    static class ModelArgsInner
    extends TableModelArgs {
        @CommandLine.Option(names={"-h", "--sourcedepth", "--evdepth"}, paramLabel="depth", defaultValue="0.0", split=",", description={"source depth in km"})
        List<Double> sourceDepth = new ArrayList<Double>();

        ModelArgsInner() {
        }
    }
}

