/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.PhaseParseException;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SetSacException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.cmdline.TauP_AbstractPhaseTool;
import edu.sc.seis.TauP.cmdline.args.GeodeticArgs;
import edu.sc.seis.TauP.cmdline.args.PhaseArgs;
import edu.sc.seis.seisFile.Location;
import edu.sc.seis.seisFile.sac.SacConstants;
import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="setsac", description={"Set headers to travel times of phases using depth and distance from SAC files."}, optionListHeading="%nOptions:%n%n", abbreviateSynopsis=false, usageHelpAutoWidth=true)
public class TauP_SetSac
extends TauP_AbstractPhaseTool {
    protected List<String> sacFileNames = new ArrayList<String>();
    protected boolean evdpkm = false;
    public static final int A_HEADER = 10;
    public static final int SKIP_HEADER = 11;
    @CommandLine.Mixin
    GeodeticArgs geodeticArgs = new GeodeticArgs();

    public boolean getEvdpkm() {
        return this.evdpkm;
    }

    @CommandLine.Option(names={"--evdpkm"}, description={"sac depth header is in km, default is meters"})
    public void setEvdpkm(boolean evdpkm) {
        this.evdpkm = evdpkm;
    }

    @CommandLine.Parameters(description={"SAC files to process"}, paramLabel="sacfile")
    public void setSacFileNames(String[] sacFileNames) {
        this.sacFileNames = new ArrayList<String>();
        this.sacFileNames.addAll(Arrays.asList(sacFileNames));
    }

    protected TauP_SetSac() {
        super(null);
    }

    protected void setSacVarNums() throws PhaseParseException, IOException {
        boolean[] headersUsed = new boolean[11];
        for (PhaseName pn : this.parsePhaseNameList()) {
            for (int t : pn.sacTNumTriplication) {
                if (t == 11) continue;
                headersUsed[t] = true;
            }
        }
        int j = 0;
        for (PhaseName pn : this.parsePhaseNameList()) {
            if (!pn.sacTNumTriplication.isEmpty()) continue;
            while (j < headersUsed.length && headersUsed[j]) {
                ++j;
            }
            if (j >= 10) break;
            pn.sacTNumTriplication.add(j);
            headersUsed[j] = true;
        }
    }

    @Override
    public String getOutputFormat() {
        return "sac";
    }

    @Override
    public void init() throws TauPException {
        super.init();
        try {
            this.setSacVarNums();
        }
        catch (IOException e) {
            throw new TauPException(e);
        }
    }

    @Override
    public void start() throws IOException, TauPException {
        if (this.sacFileNames.isEmpty()) {
            CommandLine.usage(this, System.out);
            return;
        }
        for (String filename : this.sacFileNames) {
            if (this.isVerbose()) {
                Alert.debug(filename);
            }
            this.processSacFile(new File(filename));
        }
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        this.geodeticArgs.validateArguments();
    }

    public void processSacFile(File f) throws IOException, TauPException {
        if (f.isDirectory()) {
            File[] subfiles;
            for (File subfile : subfiles = f.listFiles()) {
                if (subfile.getName().startsWith(".")) continue;
                this.processSacFile(subfile);
            }
            return;
        }
        try {
            SacTimeSeries sacFile = SacTimeSeries.read((File)f);
            this.processSacTimeSeries(sacFile, f.getName());
            sacFile.write(f);
        }
        catch (SetSacException e) {
            Alert.warning(e.getMessage() + ", skipping.");
        }
    }

    public void processSacTimeSeries(SacTimeSeries sacFile, String filenameForError) throws TauPException {
        DistanceRay rayCalculateable;
        SacHeader header = sacFile.getHeader();
        if (SacConstants.isUndef((float)header.getEvdp())) {
            throw new SetSacException("Depth not set in " + filenameForError);
        }
        if (SacConstants.isUndef((float)header.getO())) {
            throw new SetSacException("O marker not set in " + filenameForError);
        }
        if (!SacConstants.isUndef((float)header.getGcarc())) {
            if (this.isVerbose()) {
                Alert.debug("Using gcarc: " + header.getGcarc());
            }
            rayCalculateable = DistanceRay.ofDegrees(header.getGcarc());
        } else if (!SacConstants.isUndef((float)header.getDist())) {
            if (this.isVerbose()) {
                Alert.debug("Using dist: " + header.getDist());
            }
            rayCalculateable = DistanceRay.ofKilometers(header.getDist());
        } else if (!(SacConstants.isUndef((float)sacFile.getHeader().getStla()) || SacConstants.isUndef((float)sacFile.getHeader().getStlo()) || SacConstants.isUndef((float)sacFile.getHeader().getEvla()) || SacConstants.isUndef((float)sacFile.getHeader().getEvlo()))) {
            if (this.isVerbose()) {
                Alert.debug("Using stla,stlo, evla,evlo to calculate");
            }
            Alert.warning("Warning: Sac header gcarc is not set in " + filenameForError + ",", "using lat and lons to calculate distance.");
            rayCalculateable = this.geodeticArgs.isGeodetic() ? DistanceRay.ofGeodeticEventStation(new Location((double)header.getEvla(), (double)header.getEvlo(), (double)header.getEvdp()), new Location((double)header.getStla(), (double)header.getStlo()), 0.0033528106647474805) : DistanceRay.ofEventStation(new Location((double)header.getEvla(), (double)header.getEvlo(), (double)header.getEvdp()), new Location((double)header.getStla(), (double)header.getStlo()));
        } else {
            throw new SetSacException("Can't get a distance, all distance fields are undef in " + filenameForError);
        }
        if (this.modelArgs.getSourceDepths().size() != 1 || (!this.evdpkm || this.modelArgs.getSourceDepths().get(0) != (double)header.getEvdp()) && (this.evdpkm || this.modelArgs.getSourceDepths().get(0) != (double)(1000.0f * header.getEvdp()))) {
            if (!this.evdpkm && header.getEvdp() != 0.0f && (double)header.getEvdp() < 1000.0) {
                Alert.warning("Sac header evdp is < 1000 in " + filenameForError, "If the depth is in kilometers instead of meters (default), you should use the -evdpkm flag");
            }
            if (this.evdpkm) {
                this.setSingleSourceDepth(header.getEvdp());
            } else {
                this.setSingleSourceDepth((double)header.getEvdp() / 1000.0);
            }
        }
        if (this.isVerbose()) {
            Alert.debug(filenameForError + " searching for " + PhaseArgs.getPhaseNamesAsString(this.parsePhaseNameList()));
        }
        block0: for (int j = this.getSeismicPhases().size() - 1; j >= 0; --j) {
            SeismicPhase phase = this.getSeismicPhases().get(j);
            List<Arrival> arrivalList = ((RayCalculateable)rayCalculateable).calculate(phase);
            int phaseNum = -1;
            for (int pnidx = this.parsePhaseNameList().size() - 1; pnidx >= 0; --pnidx) {
                if (!phase.getName().equals(this.parsePhaseNameList().get((int)pnidx).name)) continue;
                phaseNum = pnidx;
                break;
            }
            PhaseName pn = this.parsePhaseNameList().get(phaseNum);
            int tripNum = 0;
            for (int tripHeader : pn.sacTNumTriplication) {
                if (tripNum >= arrivalList.size()) continue block0;
                Arrival tripArrival = arrivalList.get(tripNum);
                if (tripHeader != 11) {
                    if (this.isVerbose()) {
                        Alert.debug(" phase found " + pn.name + " = " + tripArrival.getName() + " trip(" + tripNum + ") -> t" + tripHeader + ", travel time=" + (float)tripArrival.getTime());
                    }
                    TauP_SetSac.setSacTHeader(sacFile, tripHeader, tripArrival);
                } else if (this.isVerbose()) {
                    Alert.debug(" phase found " + pn.name + " = " + tripArrival.getName() + " trip(" + tripNum + ") -> skip, travel time=" + (float)tripArrival.getTime());
                }
                ++tripNum;
            }
        }
    }

    public static void setSacTHeader(SacTimeSeries sacFile, int headerNum, Arrival arrival) {
        float arrivalTime = sacFile.getHeader().getO() + (float)arrival.getTime();
        if (headerNum == 10) {
            sacFile.getHeader().setA(arrivalTime);
            sacFile.getHeader().setKa(arrival.getName());
        } else {
            sacFile.getHeader().setTHeader(headerNum, arrivalTime, arrival.getName());
            sacFile.getHeader().setUserHeader(headerNum, (float)arrival.getRayParam());
        }
    }
}

