/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.Gson;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.cmdline.Result;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.args.DistanceArgs;
import edu.sc.seis.TauP.cmdline.args.DistanceLengthArgs;
import edu.sc.seis.TauP.cmdline.args.GeodeticArgs;
import edu.sc.seis.TauP.cmdline.args.LatLonAzBazArgs;
import edu.sc.seis.TauP.cmdline.args.QmlStaxmlArgs;
import edu.sc.seis.TauP.cmdline.args.TextOutputTypeArgs;
import edu.sc.seis.TauP.gson.GsonUtil;
import edu.sc.seis.seisFile.Location;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="distaz", description={"Calc distance, az and baz for event lat,lon and station lat,lon pairs."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_DistAz
extends TauP_Tool {
    @CommandLine.Mixin
    TextOutputTypeArgs outputTypeArgs;
    @CommandLine.Mixin
    LatLonAzBazArgs latLonArgs = new LatLonAzBazArgs();
    @CommandLine.Mixin
    QmlStaxmlArgs qmlStaxmlArgs = new QmlStaxmlArgs();
    @CommandLine.Mixin
    GeodeticArgs geodeticArgs = new GeodeticArgs();
    @CommandLine.ArgGroup(exclusive=false, multiplicity="0..*", heading="Optional distance is given by:%n")
    DistanceLengthArgs distArgs = new DistanceLengthArgs();
    @CommandLine.Option(names={"--radius"}, defaultValue="6371", description={"radius of earth in km, used when distance given in km"})
    protected Double radiusOfEarth = null;

    public TauP_DistAz() {
        super(new TextOutputTypeArgs("text", "-"));
        this.outputTypeArgs = (TextOutputTypeArgs)this.abstractOutputTypeArgs;
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void start() throws IOException, TauPException {
        DistanceAngleRay dr;
        Location loc;
        double lon;
        double lat;
        double kmToDeg = 57.29577951308232 * this.radiusOfEarth;
        ArrayList<Location> eventLocs = new ArrayList<Location>();
        eventLocs.addAll(this.latLonArgs.getEventLocations());
        eventLocs.addAll(this.qmlStaxmlArgs.getEventLocations());
        ArrayList<Location> staList = new ArrayList<Location>();
        staList.addAll(this.latLonArgs.getStationLocations());
        staList.addAll(this.qmlStaxmlArgs.getStationLocations());
        ArrayList<DistanceAngleRay> distList = new ArrayList<DistanceAngleRay>();
        if (this.latLonArgs.hasAzimuth()) {
            for (Location evtLoc : eventLocs) {
                String evtDesc = QmlStaxmlArgs.createDescription(evtLoc);
                for (Double d : this.createDistDegreeList()) {
                    lat = SphericalCoords.latFor(evtLoc, d, this.latLonArgs.getAzimuth());
                    lon = SphericalCoords.lonFor(evtLoc, d, this.latLonArgs.getAzimuth());
                    loc = new Location(lat, lon);
                    dr = DistanceRay.ofEventStation(evtLoc, loc);
                    dr.setDescription(evtDesc + " to " + QmlStaxmlArgs.createDescription(loc));
                    distList.add(dr);
                }
            }
        }
        if (this.latLonArgs.hasBackAzimuth()) {
            for (Location staLoc : staList) {
                Iterator staDesc = QmlStaxmlArgs.createDescription(staLoc);
                for (Double d : this.createDistDegreeList()) {
                    lat = SphericalCoords.latFor(staLoc, d, this.latLonArgs.getBackAzimuth());
                    lon = SphericalCoords.lonFor(staLoc, d, this.latLonArgs.getBackAzimuth());
                    loc = new Location(lat, lon);
                    dr = DistanceRay.ofEventStation(loc, staLoc);
                    dr.setDescription(QmlStaxmlArgs.createDescription(loc) + " to " + staDesc);
                    distList.add(dr);
                }
            }
        }
        for (Location evtLoc : eventLocs) {
            for (Location staLoc : staList) {
                DistanceAngleRay dr2 = this.geodeticArgs.isGeodetic() ? DistanceRay.ofGeodeticEventStation(evtLoc, staLoc, this.geodeticArgs.getInverseEllipFlattening()) : DistanceRay.ofEventStation(evtLoc, staLoc);
                String staDesc = QmlStaxmlArgs.createDescription(staLoc);
                String evtDesc = QmlStaxmlArgs.createDescription(evtLoc);
                dr2.setDescription(evtDesc + " to " + staDesc);
                distList.add(dr2);
            }
        }
        distList.sort((lhs, rhs) -> Double.compare(lhs.getDegrees(), rhs.getDegrees()));
        PrintWriter out = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        if (this.outputTypeArgs.isText()) {
            String geoditic = this.geodeticArgs.isGeodetic() ? "Geodetic " + this.geodeticArgs.getInverseEllipFlattening() : "Spherical";
            out.println("Degrees      Km     Azimuth  BackAzimuth  Description   (" + geoditic + ")  ");
            out.println("----------------------------------------------------------------------");
            for (DistanceAngleRay dr3 : distList) {
                out.println(Outputs.formatDistance(dr3.getDegrees()) + " " + Outputs.formatKilometer(dr3.getKilometers(this.radiusOfEarth)) + " " + Outputs.formatDistance(dr3.getNormalizedAzimuth()) + "  " + Outputs.formatDistance(dr3.getNormalizedBackAzimuth()) + "      " + (dr3.hasDescription() ? dr3.getDescription() : ""));
            }
        } else if (this.outputTypeArgs.isJSON()) {
            Result result = new Result();
            result.calctype = this.geodeticArgs.getCalcType();
            if (this.geodeticArgs.isGeodetic()) {
                result.invflattening = this.geodeticArgs.getInverseEllipFlattening();
            }
            result.sources = eventLocs;
            result.receivers = staList;
            result.distances = distList;
            Gson gson = GsonUtil.createGsonBuilder().create();
            out.println(gson.toJson((Object)result));
        }
        out.flush();
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        if (!(this.distArgs.allEmpty() || this.latLonArgs.hasAzimuth() || this.latLonArgs.hasBackAzimuth())) {
            throw new IllegalArgumentException("Distance only used with azimuth or backazimuth");
        }
        if (this.distArgs.allEmpty() && (this.latLonArgs.hasAzimuth() || this.latLonArgs.hasBackAzimuth())) {
            throw new IllegalArgumentException("Azimuth and backazimuth require distance in deg or km");
        }
        if (this.geodeticArgs.isGeodetic() && (this.latLonArgs.hasBackAzimuth() || this.latLonArgs.hasAzimuth())) {
            throw new IllegalArgumentException("Unable to project for az,baz with geodetic, only for spherical");
        }
        if (this.latLonArgs.getEventLocations().isEmpty() && !this.qmlStaxmlArgs.hasQml() && !this.latLonArgs.hasBackAzimuth()) {
            throw new IllegalArgumentException("Either back azimuth, event lat,lon or QuakeML file must be given");
        }
        if (this.latLonArgs.getStationLocations().isEmpty() && !this.qmlStaxmlArgs.hasStationXML() && !this.latLonArgs.hasAzimuth()) {
            throw new IllegalArgumentException("Either azimuth, station lat,lon or StationXML file must be given");
        }
        this.latLonArgs.validateArguments();
        this.geodeticArgs.validateArguments();
    }

    public List<Double> createDistDegreeList() {
        ArrayList<Double> allDeg = new ArrayList<Double>(this.distArgs.degreesList);
        if (!this.distArgs.degreeRange.isEmpty()) {
            allDeg.addAll(DistanceArgs.createListFromRange(this.distArgs.degreeRange, 10.0, 180.0, 10.0));
        }
        ArrayList<Double> allKm = new ArrayList<Double>(this.distArgs.distKilometersList);
        if (!this.distArgs.kilometerRange.isEmpty()) {
            allKm.addAll(DistanceArgs.createListFromRange(this.distArgs.kilometerRange, 100.0, 1000.0, 100.0));
        }
        if (!allKm.isEmpty()) {
            double kmToDeg = this.kmToDeg();
            for (Double km : allKm) {
                allDeg.add(km * kmToDeg);
            }
        }
        return allDeg;
    }

    public Double kmToDeg() {
        double r = this.radiusOfEarth != null ? this.radiusOfEarth : 6371.0;
        return 57.29577951308232 / r;
    }
}

