/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.seisFile.Location;

public class SphericalCoords {
    protected static final double dtor = Math.PI / 180;
    public static final double DtoR = Math.PI / 180;
    protected static final double rtod = 57.29577951308232;
    public static final double RtoD = 57.29577951308232;
    public static final double TWOPI = Math.PI * 2;

    public static double distance(double latA, double lonA, double latB, double lonB) {
        return 57.29577951308232 * Math.acos(Math.sin(latA * (Math.PI / 180)) * Math.sin(latB * (Math.PI / 180)) + Math.cos(latA * (Math.PI / 180)) * Math.cos(latB * (Math.PI / 180)) * Math.cos((lonB - lonA) * (Math.PI / 180)));
    }

    public static double distance(Location a, Location b) {
        return SphericalCoords.distance(a.getLatitude(), a.getLongitude(), b.getLatitude(), b.getLongitude());
    }

    public static double azimuth(double latA, double lonA, double latB, double lonB) {
        double cosAzimuth = (Math.cos(latA * (Math.PI / 180)) * Math.sin(latB * (Math.PI / 180)) - Math.sin(latA * (Math.PI / 180)) * Math.cos(latB * (Math.PI / 180)) * Math.cos((lonB - lonA) * (Math.PI / 180))) / Math.sin(SphericalCoords.distance(latA, lonA, latB, lonB) * (Math.PI / 180));
        double sinAzimuth = Math.cos(latB * (Math.PI / 180)) * Math.sin((lonB - lonA) * (Math.PI / 180)) / Math.sin(SphericalCoords.distance(latA, lonA, latB, lonB) * (Math.PI / 180));
        return 57.29577951308232 * Math.atan2(sinAzimuth, cosAzimuth);
    }

    public static double azimuth(Location a, Location b) {
        return SphericalCoords.azimuth(a.getLatitude(), a.getLongitude(), b.getLatitude(), b.getLongitude());
    }

    public static double[] rotationPole(double latA, double lonA, double latB, double lonB) {
        double[] pointA = new double[3];
        double[] pointB = new double[3];
        double[] pole = new double[3];
        double dToR = Math.PI / 180;
        pointA[0] = Math.cos(latA * dToR) * Math.cos(lonA * dToR);
        pointA[1] = Math.cos(latA * dToR) * Math.sin(lonA * dToR);
        pointA[2] = Math.sin(latA * dToR);
        pointB[0] = Math.cos(latB * dToR) * Math.cos(lonB * dToR);
        pointB[1] = Math.cos(latB * dToR) * Math.sin(lonB * dToR);
        pointB[2] = Math.sin(latB * dToR);
        pole[0] = pointA[1] * pointB[2] - pointA[2] * pointB[1];
        pole[1] = pointA[2] * pointB[0] - pointA[0] * pointB[2];
        pole[2] = pointA[0] * pointB[1] - pointA[1] * pointB[0];
        return pole;
    }

    public static double[] rotate(double latA, double lonA, double[] pole, double angleDeg) {
        double[][] R = new double[3][3];
        double[] point = new double[3];
        double[] newPoint = new double[3];
        double rToDeg = 57.29577951308232;
        double angle = angleDeg / rToDeg;
        R[0][0] = pole[0] * pole[0] * (1.0 - Math.cos(angle)) + Math.cos(angle);
        R[0][1] = pole[0] * pole[1] * (1.0 - Math.cos(angle)) - pole[2] * Math.sin(angle);
        R[0][2] = pole[0] * pole[2] * (1.0 - Math.cos(angle)) + pole[1] * Math.sin(angle);
        R[1][0] = pole[1] * pole[0] * (1.0 - Math.cos(angle)) + pole[2] * Math.sin(angle);
        R[1][1] = pole[1] * pole[1] * (1.0 - Math.cos(angle)) + Math.cos(angle);
        R[1][2] = pole[1] * pole[2] * (1.0 - Math.cos(angle)) - pole[0] * Math.sin(angle);
        R[2][0] = pole[2] * pole[0] * (1.0 - Math.cos(angle)) - pole[1] * Math.sin(angle);
        R[2][1] = pole[2] * pole[1] * (1.0 - Math.cos(angle)) + pole[0] * Math.sin(angle);
        R[2][2] = pole[2] * pole[2] * (1.0 - Math.cos(angle)) + Math.cos(angle);
        point[0] = Math.cos(latA / rToDeg) * Math.cos(lonA / rToDeg);
        point[1] = Math.cos(latA / rToDeg) * Math.sin(lonA / rToDeg);
        point[2] = Math.sin(latA / rToDeg);
        newPoint[0] = R[0][0] * point[0] + R[0][1] * point[1] + R[0][2] * point[2];
        newPoint[1] = R[1][0] * point[0] + R[1][1] * point[1] + R[1][2] * point[2];
        newPoint[2] = R[2][0] * point[0] + R[2][1] * point[1] + R[2][2] * point[2];
        double newLat = Math.asin(newPoint[2]) * 180.0 / Math.PI;
        double newLon = Math.atan2(newPoint[1], newPoint[0]) * 180.0 / Math.PI;
        newPoint = new double[]{newLat, newLon};
        return newPoint;
    }

    public static double latFor(Location a, double distance, double azimuth) {
        return SphericalCoords.latFor(a.getLatitude(), a.getLongitude(), distance, azimuth);
    }

    public static double latFor(double latA, double lonA, double distance, double azimuth) {
        return 57.29577951308232 * Math.asin(Math.cos(azimuth * (Math.PI / 180)) * Math.sin(distance * (Math.PI / 180)) * Math.cos(latA * (Math.PI / 180)) + Math.cos(distance * (Math.PI / 180)) * Math.sin(latA * (Math.PI / 180)));
    }

    public static double lonFor(Location a, double distance, double azimuth) {
        return SphericalCoords.lonFor(a.getLatitude(), a.getLongitude(), distance, azimuth);
    }

    public static double lonFor(double latA, double lonA, double distance, double azimuth) {
        double cosLon;
        double tempLat = SphericalCoords.latFor(latA, lonA, distance, azimuth);
        double sinLon = Math.sin(azimuth * (Math.PI / 180)) * Math.sin(distance * (Math.PI / 180)) / Math.cos(tempLat * (Math.PI / 180));
        double lon = lonA + 57.29577951308232 * Math.atan2(sinLon, cosLon = (Math.cos(distance * (Math.PI / 180)) - Math.sin(latA * (Math.PI / 180)) * Math.sin(tempLat * (Math.PI / 180))) / (Math.cos(latA * (Math.PI / 180)) * Math.cos(tempLat * (Math.PI / 180))));
        if (lon <= -180.0) {
            lon += 360.0;
        }
        if (lon > 180.0) {
            lon -= 360.0;
        }
        return lon;
    }
}

