/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.TauBranch;

public class ShadowZone {
    private final TauBranch hszBranch;
    double rayParam;
    Arrival postArrival;
    Arrival preArrival;
    boolean isPWave;

    public ShadowZone(double rayParam, TauBranch hszBranch) {
        this.rayParam = rayParam;
        this.hszBranch = hszBranch;
    }

    public void setPrePostArrival(Arrival preArrival, Arrival postArrival) {
        this.postArrival = postArrival;
        this.preArrival = preArrival;
    }

    public String toString() {
        return this.preArrival.getName() + " Shadow zone for ray param " + Outputs.formatRayParam(Math.PI / 180 * this.getRayParam()) + " s/deg  depths " + this.hszBranch.getTopDepth() + " to " + this.hszBranch.getBotDepth() + ",  between arrivals:\n  " + Arrival.toStringHeader() + "\n  " + this.preArrival.toString() + "\n  " + this.postArrival.toString();
    }

    public double getRayParam() {
        return this.rayParam;
    }

    public double getTopDepth() {
        return this.hszBranch.getTopDepth();
    }

    public double getBotDepth() {
        return this.hszBranch.getBotDepth();
    }

    public Arrival getPostArrival() {
        return this.postArrival;
    }

    public Arrival getPreArrival() {
        return this.preArrival;
    }
}

