/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DistAz;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceKmRay;
import edu.sc.seis.TauP.EventAzimuth;
import edu.sc.seis.TauP.EventStation;
import edu.sc.seis.TauP.ExactDistanceRay;
import edu.sc.seis.TauP.FixedHemisphereDistanceRay;
import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.ScatteredArrival;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.StationBackAzimuth;
import edu.sc.seis.seisFile.Location;
import java.util.ArrayList;
import java.util.List;

public abstract class DistanceRay
extends RayCalculateable
implements Cloneable {
    DistanceRay() {
    }

    public static FixedHemisphereDistanceRay ofFixedHemisphereDegrees(double deg) {
        FixedHemisphereDistanceRay val = new FixedHemisphereDistanceRay(DistanceRay.ofExactDegrees(deg));
        return val;
    }

    public static FixedHemisphereDistanceRay ofFixedHemisphereKilometers(double km) {
        FixedHemisphereDistanceRay val = new FixedHemisphereDistanceRay(DistanceRay.ofExactKilometers(km));
        return val;
    }

    public static FixedHemisphereDistanceRay ofFixedHemisphereRadians(double rad) {
        FixedHemisphereDistanceRay val = new FixedHemisphereDistanceRay(DistanceRay.ofExactRadians(rad));
        return val;
    }

    void copyFrom(DistanceRay dr) {
        this.staLatLon = dr.staLatLon;
        this.evtLatLon = dr.evtLatLon;
        this.azimuth = dr.azimuth;
        this.backAzimuth = dr.backAzimuth;
        this.geodetic = dr.geodetic;
        this.invFlattening = dr.invFlattening;
    }

    public static DistanceAngleRay ofDegrees(double deg) {
        DistanceAngleRay val = new DistanceAngleRay();
        val.degrees = deg;
        return val;
    }

    public static DistanceKmRay ofKilometers(double km) {
        DistanceKmRay val = new DistanceKmRay(km);
        return val;
    }

    public static DistanceAngleRay ofRadians(double rad) {
        DistanceAngleRay val = new DistanceAngleRay();
        val.radians = rad;
        return val;
    }

    public static ExactDistanceRay ofExactDegrees(double deg) {
        ExactDistanceRay val = new ExactDistanceRay(DistanceRay.ofDegrees(deg));
        return val;
    }

    public static ExactDistanceRay ofExactKilometers(double km) {
        ExactDistanceRay val = new ExactDistanceRay(DistanceRay.ofKilometers(km));
        return val;
    }

    public static ExactDistanceRay ofExactRadians(double rad) {
        ExactDistanceRay val = new ExactDistanceRay(DistanceRay.ofRadians(rad));
        return val;
    }

    public static DistanceAngleRay ofEventStation(Location evt, Location sta) {
        DistanceAngleRay val = DistanceRay.ofDegrees(SphericalCoords.distance(evt, sta));
        val.evtLatLon = evt;
        val.staLatLon = sta;
        val.azimuth = SphericalCoords.azimuth(evt, sta);
        val.backAzimuth = SphericalCoords.azimuth(sta, evt);
        return val;
    }

    public static DistanceAngleRay ofGeodeticEventStation(Location evt, Location sta, double invFlattening) {
        DistAz distAz = new DistAz(evt, sta, 1.0 / invFlattening);
        DistanceAngleRay val = DistanceRay.ofDegrees(distAz.getDelta());
        val.staLatLon = sta;
        val.evtLatLon = evt;
        val.azimuth = distAz.getAz();
        val.backAzimuth = distAz.getBaz();
        val.invFlattening = invFlattening;
        val.geodetic = true;
        return val;
    }

    @Override
    public List<Arrival> calculate(SeismicPhase phase) {
        List<Arrival> phaseArrivals = phase instanceof SimpleSeismicPhase ? this.calcSimplePhase((SimpleSeismicPhase)phase) : this.calcScatteredPhase((ScatteredSeismicPhase)phase);
        return phaseArrivals;
    }

    public List<Arrival> calcSimplePhase(SimpleSeismicPhase phase) {
        List<Double> arrivalDistList = this.calcRadiansInRange(phase.getMinDistance(), phase.getMaxDistance(), phase.getTauModel().getRadiusOfEarth(), true);
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (Double distRadian : arrivalDistList) {
            arrivals.addAll(phase.calcTimeExactDistance(distRadian));
        }
        for (Arrival a : arrivals) {
            a.setSearchValue(this);
        }
        return Arrival.sortArrivals(arrivals);
    }

    public List<Arrival> calcScatteredPhase(ScatteredSeismicPhase phase) {
        double deg = this.getDegrees(phase.getTauModel().getRadiusOfEarth());
        double scatDistDeg = ScatteredSeismicPhase.calcScatterDistDeg(deg, phase.getScattererDistanceDeg(), phase.isBackscatter());
        ExactDistanceRay scatRay = DistanceRay.ofExactDegrees(Math.abs(scatDistDeg));
        SimpleSeismicPhase scatteredPhase = phase.getScatteredPhase();
        List<Double> arrivalDistList = scatRay.calcRadiansInRange(scatteredPhase.getMinDistance(), scatteredPhase.getMaxDistance(), phase.getTauModel().getRadiusOfEarth(), false);
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (Double distRadian : arrivalDistList) {
            arrivals.addAll(phase.getScatteredPhase().calcTimeExactDistance(distRadian));
        }
        ArrayList<Arrival> scatArrivals = new ArrayList<Arrival>();
        for (Arrival a : arrivals) {
            a.setSearchValue(scatRay);
            if (scatDistDeg < 0.0) {
                a.negateDistance();
            }
            scatArrivals.add(new ScatteredArrival(phase, this, phase.getInboundArrival(), a, phase.isBackscatter()));
        }
        return Arrival.sortArrivals(scatArrivals);
    }

    public abstract double getDegrees(double var1);

    public abstract double getRadians(double var1);

    public abstract double getKilometers(double var1);

    public List<Double> calcRadiansInRange(double minRadian, double maxRadian, double radius, boolean phaseBothHemisphere) {
        ArrayList<Double> out = new ArrayList<Double>();
        double radianVal = this.getRadians(radius) % (Math.PI * 2);
        if ((radianVal - minRadian) % (Math.PI * 2) == 0.0) {
            out.add(minRadian);
        }
        int n = (int)Math.floor(minRadian / (Math.PI * 2));
        while ((double)n * 2.0 * Math.PI < maxRadian) {
            double searchVal = (double)n * 2.0 * Math.PI + radianVal;
            if (minRadian < searchVal && searchVal <= maxRadian) {
                out.add(searchVal);
            }
            if (radianVal != Math.PI && minRadian < (searchVal = (double)(n + 1) * 2.0 * Math.PI - radianVal) && searchVal <= maxRadian) {
                out.add(searchVal);
            }
            ++n;
        }
        return out;
    }

    @Override
    public boolean isLatLonable() {
        return this.staLatLon != null && this.evtLatLon != null || this.staLatLon != null && this.backAzimuth != null || this.evtLatLon != null && this.azimuth != null;
    }

    @Override
    public LatLonable getLatLonable() {
        if (this.staLatLon != null && this.evtLatLon != null) {
            return new EventStation(this.evtLatLon, this.staLatLon);
        }
        if (this.staLatLon != null && this.backAzimuth != null) {
            return new StationBackAzimuth(this.staLatLon, this.backAzimuth);
        }
        if (this.evtLatLon != null && this.azimuth != null) {
            return new EventAzimuth(this.evtLatLon, this.azimuth);
        }
        return null;
    }

    public static DistanceRay duplicate(DistanceRay dr) {
        if (dr instanceof DistanceAngleRay) {
            return ((DistanceAngleRay)dr).duplicate();
        }
        if (dr instanceof DistanceKmRay) {
            return ((DistanceKmRay)dr).duplicate();
        }
        if (dr instanceof ExactDistanceRay) {
            return ((ExactDistanceRay)dr).duplicate();
        }
        if (dr instanceof FixedHemisphereDistanceRay) {
            return ((FixedHemisphereDistanceRay)dr).duplicate();
        }
        throw new RuntimeException("Duplicate unknown DistanceRay type: " + dr.getClass().getName());
    }
}

